/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.LazyArrayContext;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Map;
import java.util.stream.Collectors;

public class FunctionEvaluator {
    private final ExpressionFunction function;
    private final LazyArrayContext context;
    private boolean evaluated = false;

    FunctionEvaluator(ExpressionFunction function, LazyArrayContext context) {
        this.function = function;
        this.context = context;
    }

    public FunctionEvaluator bind(String name, Tensor value) {
        if (this.evaluated) {
            throw new IllegalStateException("Cannot bind a new value in a used evaluator");
        }
        TensorType requiredType = (TensorType)this.function.argumentTypes().get(name);
        if (requiredType == null) {
            throw new IllegalArgumentException("'" + name + "' is not a valid argument in " + this.function + ". Expected arguments: " + this.function.argumentTypes().entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ")));
        }
        if (!value.type().isAssignableTo(requiredType)) {
            throw new IllegalArgumentException("'" + name + "' must be of type " + requiredType + ", not " + value.type());
        }
        this.context.put(name, (Value)new TensorValue(value));
        return this;
    }

    public FunctionEvaluator bind(String name, double value) {
        return this.bind(name, Tensor.Builder.of((TensorType)TensorType.empty).cell(value, new long[0]).build());
    }

    public FunctionEvaluator setMissingValue(Tensor value) {
        if (this.evaluated) {
            throw new IllegalStateException("Cannot change the missing value in a used evaluator");
        }
        this.context.setMissingValue(value);
        return this;
    }

    public FunctionEvaluator setMissingValue(double value) {
        return this.setMissingValue(Tensor.Builder.of((TensorType)TensorType.empty).cell(value, new long[0]).build());
    }

    public Tensor evaluate() {
        for (Map.Entry argument : this.function.argumentTypes().entrySet()) {
            if (this.context.isMissing((String)argument.getKey())) {
                throw new IllegalStateException("Missing argument '" + (String)argument.getKey() + "': Must be bound to a value of type " + argument.getValue());
            }
            if (this.context.get((String)argument.getKey()).type().isAssignableTo((TensorType)argument.getValue())) continue;
            throw new IllegalStateException("Argument '" + (String)argument.getKey() + "' must be bound to a value of type " + argument.getValue());
        }
        this.evaluated = true;
        return this.function.getBody().evaluate((Context)this.context).asTensor();
    }

    public ExpressionFunction function() {
        return this.function;
    }

    public LazyArrayContext context() {
        return this.context;
    }
}

