/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.FunctionEvaluator;
import ai.vespa.models.evaluation.Model;
import ai.vespa.models.evaluation.RankProfilesConfigImporter;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.yahoo.component.AbstractComponent;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.util.Map;

@Beta
public class ModelsEvaluator
extends AbstractComponent {
    private final ImmutableMap<String, Model> models;

    public ModelsEvaluator(RankProfilesConfig config) {
        this.models = ImmutableMap.copyOf(new RankProfilesConfigImporter().importFrom(config));
    }

    public Map<String, Model> models() {
        return this.models;
    }

    public FunctionEvaluator evaluatorOf(String modelName, String ... names) {
        return this.requireModel(modelName).evaluatorOf(names);
    }

    public Model requireModel(String name) {
        Model model = (Model)this.models.get((Object)name);
        if (model == null) {
            throw new IllegalArgumentException("No model named '" + name + "'. Available models: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)this.models.keySet()));
        }
        return model;
    }
}

