/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.FunctionEvaluator;
import ai.vespa.models.evaluation.Model;
import ai.vespa.models.evaluation.RankProfilesConfigImporter;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.util.Map;
import java.util.stream.Collectors;

@Beta
public class ModelsEvaluator {
    private final ImmutableMap<String, Model> models;

    public ModelsEvaluator(RankProfilesConfig config) {
        this.models = ImmutableMap.copyOf(new RankProfilesConfigImporter().importFrom(config));
    }

    public Map<String, Model> models() {
        return this.models;
    }

    public FunctionEvaluator evaluatorOf(String modelName, String functionName) {
        return this.requireModel(modelName).evaluatorOf(functionName);
    }

    Model requireModel(String name) {
        Model model = (Model)this.models.get((Object)name);
        if (model == null) {
            throw new IllegalArgumentException("No model named '" + name + ". Available models: " + this.models.keySet().stream().collect(Collectors.joining(", ")));
        }
        return model;
    }
}

