/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.FunctionReference;
import ai.vespa.models.evaluation.LazyValue;
import ai.vespa.models.evaluation.Model;
import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.ContextIndex;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class LazyArrayContext
extends Context
implements ContextIndex {
    private final IndexedBindings indexedBindings;

    private LazyArrayContext(IndexedBindings indexedBindings) {
        this.indexedBindings = indexedBindings.copy(this);
    }

    LazyArrayContext(RankingExpression expression, Map<FunctionReference, ExpressionFunction> functions, Model model) {
        this.indexedBindings = new IndexedBindings(expression, functions, this, model);
    }

    public void put(String name, Value value) {
        this.put((int)this.requireIndexOf(name), value);
    }

    public final void put(int index, double value) {
        this.put(index, (Value)DoubleValue.frozen((double)value));
    }

    public void put(int index, Value value) {
        this.indexedBindings.set(index, value.freeze());
    }

    public TensorType getType(Reference reference) {
        return this.get(this.requireIndexOf(reference.toString())).type();
    }

    public Value get(String name) {
        return this.get(this.requireIndexOf(name));
    }

    public Value get(int index) {
        return this.indexedBindings.get(index);
    }

    public double getDouble(int index) {
        double value = this.get(index).asDouble();
        if (value == Double.NaN) {
            throw new UnsupportedOperationException("Value at " + index + " has no double representation");
        }
        return value;
    }

    public int getIndex(String name) {
        return this.requireIndexOf(name);
    }

    public int size() {
        return this.indexedBindings.names().size();
    }

    public Set<String> names() {
        return this.indexedBindings.names();
    }

    private Integer requireIndexOf(String name) {
        Integer index = this.indexedBindings.indexOf(name);
        if (index == null) {
            throw new IllegalArgumentException("Value '" + name + "' can not be bound in " + (Object)((Object)this));
        }
        return index;
    }

    LazyArrayContext copy() {
        return new LazyArrayContext(this.indexedBindings);
    }

    private static class IndexedBindings {
        private final ImmutableMap<String, Integer> nameToIndex;
        private final Value[] values;

        private IndexedBindings(ImmutableMap<String, Integer> nameToIndex, Value[] values) {
            this.nameToIndex = nameToIndex;
            this.values = values;
        }

        IndexedBindings(RankingExpression expression, Map<FunctionReference, ExpressionFunction> functions, LazyArrayContext owner, Model model) {
            LinkedHashSet<String> bindTargets = new LinkedHashSet<String>();
            this.extractBindTargets(expression.getRoot(), functions, bindTargets);
            this.values = new Value[bindTargets.size()];
            Arrays.fill(this.values, DoubleValue.zero);
            int i = 0;
            ImmutableMap.Builder nameToIndexBuilder = new ImmutableMap.Builder();
            for (String string : bindTargets) {
                nameToIndexBuilder.put((Object)string, (Object)i++);
            }
            this.nameToIndex = nameToIndexBuilder.build();
            for (Map.Entry entry : functions.entrySet()) {
                Integer index = (Integer)this.nameToIndex.get((Object)((FunctionReference)entry.getKey()).serialForm());
                if (index == null) continue;
                this.values[index.intValue()] = new LazyValue((FunctionReference)entry.getKey(), owner, model);
            }
        }

        private void extractBindTargets(ExpressionNode node, Map<FunctionReference, ExpressionFunction> functions, Set<String> bindTargets) {
            if (this.isFunctionReference(node)) {
                FunctionReference reference = FunctionReference.fromSerial(node.toString()).get();
                bindTargets.add(reference.serialForm());
                this.extractBindTargets(functions.get(reference).getBody().getRoot(), functions, bindTargets);
            } else if (!this.isConstant(node)) {
                if (node instanceof ReferenceNode) {
                    bindTargets.add(node.toString());
                } else if (node instanceof CompositeNode) {
                    CompositeNode cNode = (CompositeNode)node;
                    for (ExpressionNode child : cNode.children()) {
                        this.extractBindTargets(child, functions, bindTargets);
                    }
                }
            }
        }

        private boolean isFunctionReference(ExpressionNode node) {
            if (!(node instanceof ReferenceNode)) {
                return false;
            }
            ReferenceNode reference = (ReferenceNode)node;
            return reference.getName().equals("rankingExpression") && reference.getArguments().size() == 1;
        }

        private boolean isConstant(ExpressionNode node) {
            if (!(node instanceof ReferenceNode)) {
                return false;
            }
            ReferenceNode reference = (ReferenceNode)node;
            return reference.getName().equals("value") && reference.getArguments().size() == 1;
        }

        Value get(int index) {
            return this.values[index];
        }

        void set(int index, Value value) {
            this.values[index] = value;
        }

        Set<String> names() {
            return this.nameToIndex.keySet();
        }

        Integer indexOf(String name) {
            return (Integer)this.nameToIndex.get((Object)name);
        }

        IndexedBindings copy(Context context) {
            Value[] valueCopy = new Value[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valueCopy[i] = this.values[i] instanceof LazyValue ? ((LazyValue)this.values[i]).copyFor(context) : this.values[i];
            }
            return new IndexedBindings(this.nameToIndex, valueCopy);
        }
    }
}

