/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model;

public enum StatusCode {
    UP(0, "up"),
    DOWN(1, "down"),
    UNKNOWN(2, "unknown");

    public final int code;
    public final String status;

    private StatusCode(int code, String status) {
        this.code = code;
        this.status = status;
    }

    public static StatusCode fromString(String statusString) {
        if ("ok".equalsIgnoreCase(statusString)) {
            return UP;
        }
        try {
            return StatusCode.valueOf(statusString.trim().toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return UNKNOWN;
        }
    }
}

