/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.prometheus;

import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.metric.model.prometheus.PrometheusModel;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PrometheusUtil {
    public static String sanitize(String name) {
        String sanitized = Collector.sanitizeMetricName((String)name);
        return name.equals(sanitized) ? name : sanitized;
    }

    public static PrometheusModel toPrometheusModel(List<MetricsPacket> metricsPackets) {
        HashSet<MetricId> metricNames = new HashSet<MetricId>();
        for (MetricsPacket metricsPacket : metricsPackets) {
            metricNames.addAll(metricsPacket.metrics().keySet());
        }
        Map<ServiceId, List<MetricsPacket>> packetsByService = metricsPackets.stream().collect(Collectors.groupingBy(packet -> packet.service));
        ArrayList<Collector.MetricFamilySamples> statusMetrics = new ArrayList<Collector.MetricFamilySamples>(packetsByService.size());
        packetsByService.forEach((serviceId, packets) -> {
            String serviceName = serviceId.getIdForPrometheus();
            if (!packets.isEmpty()) {
                MetricsPacket firstPacket = (MetricsPacket)packets.get(0);
                String statusMetricName = serviceName + "_status";
                boolean statusMetricValue = firstPacket.statusCode == 0;
                List<Collector.MetricFamilySamples.Sample> sampleList = List.of(new Collector.MetricFamilySamples.Sample(statusMetricName, List.of(), List.of(), (double)statusMetricValue, Long.valueOf(firstPacket.timestamp * 1000L)));
                statusMetrics.add(new Collector.MetricFamilySamples(statusMetricName, Collector.Type.UNKNOWN, "status of service", sampleList));
            }
        });
        return new PrometheusModel(metricNames, packetsByService, statusMetrics);
    }
}

