/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.prometheus;

import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.metric.model.prometheus.PrometheusRenderingException;
import io.prometheus.client.Collector;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrometheusModel
implements Enumeration<Collector.MetricFamilySamples> {
    private final Map<ServiceId, List<MetricsPacket>> packetsByServiceId;
    private final Iterator<MetricId> metricIterator;
    private final Iterator<Collector.MetricFamilySamples> statusMetrics;

    PrometheusModel(Set<MetricId> metricNames, Map<ServiceId, List<MetricsPacket>> packetsByServiceId, List<Collector.MetricFamilySamples> statusMetrics) {
        this.metricIterator = metricNames.iterator();
        this.packetsByServiceId = packetsByServiceId;
        this.statusMetrics = statusMetrics.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        return this.metricIterator.hasNext() || this.statusMetrics.hasNext();
    }

    @Override
    public Collector.MetricFamilySamples nextElement() {
        return this.metricIterator.hasNext() ? this.createMetricFamily(this.metricIterator.next()) : this.statusMetrics.next();
    }

    public String serialize() {
        StringWriter writer = new StringWriter();
        try {
            TextFormat.write004((Writer)writer, (Enumeration)this);
        }
        catch (Exception e) {
            throw new PrometheusRenderingException("Could not render metrics. Check the log for details.", e);
        }
        return writer.toString();
    }

    private Collector.MetricFamilySamples createMetricFamily(MetricId metricId) {
        ArrayList sampleList = new ArrayList();
        this.packetsByServiceId.forEach((serviceId, packets) -> {
            for (MetricsPacket packet : packets) {
                Number metric = packet.metrics().get(metricId);
                if (metric == null) continue;
                sampleList.add(PrometheusModel.createSample(serviceId, metricId, metric, packet.timestamp, packet.dimensions()));
            }
        });
        return new Collector.MetricFamilySamples(metricId.getIdForPrometheus(), Collector.Type.UNKNOWN, "", sampleList);
    }

    private static Collector.MetricFamilySamples.Sample createSample(ServiceId serviceId, MetricId metricId, Number metric, Long timeStamp, Map<DimensionId, String> dimensions) {
        ArrayList<String> labels = new ArrayList<String>(dimensions.size());
        ArrayList<String> labelValues = new ArrayList<String>(dimensions.size());
        for (Map.Entry<DimensionId, String> entry : dimensions.entrySet()) {
            String labelName = entry.getKey().getIdForPrometheus();
            labels.add(labelName);
            labelValues.add(entry.getValue());
        }
        labels.add("vespa_service");
        labelValues.add(serviceId.getIdForPrometheus());
        return new Collector.MetricFamilySamples.Sample(metricId.getIdForPrometheus(), labels, labelValues, metric.doubleValue(), timeStamp);
    }
}

