/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.json.Jackson;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetricsParser {
    private static final ObjectMapper jsonMapper = Jackson.mapper();

    public static void parse(String data, Collector consumer) throws IOException {
        try (JsonParser parser = jsonMapper.createParser(data);){
            MetricsParser.parse(parser, consumer);
        }
    }

    static void parse(InputStream data, Collector consumer) throws IOException {
        try (JsonParser parser = jsonMapper.createParser(data);){
            MetricsParser.parse(parser, consumer);
        }
    }

    private static void parse(JsonParser parser, Collector consumer) throws IOException {
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected start of object, got " + parser.currentToken());
        }
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            if (fieldName.equals("metrics")) {
                MetricsParser.parseMetrics(parser, consumer);
            } else if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                parser.skipChildren();
            }
            parser.nextToken();
        }
    }

    private static Instant parseSnapshot(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected start of 'snapshot' object, got " + parser.currentToken());
        }
        Instant timestamp = Instant.now();
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            if (fieldName.equals("to")) {
                timestamp = Instant.ofEpochSecond(parser.getLongValue());
                timestamp = Instant.ofEpochSecond(Metric.adjustTime(timestamp.getEpochSecond(), Instant.now().getEpochSecond()));
            } else if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                parser.skipChildren();
            }
            parser.nextToken();
        }
        return timestamp;
    }

    private static void parseMetrics(JsonParser parser, Collector consumer) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected start of 'metrics' object, got " + parser.currentToken());
        }
        Instant timestamp = Instant.now();
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            if (fieldName.equals("snapshot")) {
                timestamp = MetricsParser.parseSnapshot(parser);
            } else if (fieldName.equals("values")) {
                MetricsParser.parseMetricValues(parser, timestamp, consumer);
            } else if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                parser.skipChildren();
            }
            parser.nextToken();
        }
    }

    private static void parseMetricValues(JsonParser parser, Instant timestamp, Collector consumer) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new IOException("Expected start of 'metrics:values' array, got " + parser.currentToken());
        }
        HashMap<Set<Dimension>, Map<DimensionId, String>> uniqueDimensions = new HashMap<Set<Dimension>, Map<DimensionId, String>>();
        while (parser.nextToken() == JsonToken.START_OBJECT) {
            MetricsParser.handleValue(parser, timestamp, consumer, uniqueDimensions);
        }
    }

    private static void handleValue(JsonParser parser, Instant timestamp, Collector consumer, Map<Set<Dimension>, Map<DimensionId, String>> uniqueDimensions) throws IOException {
        String name = "";
        String description = "";
        Map<DimensionId, String> dim = Map.of();
        List<Object> values = List.of();
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.getText();
                    break;
                }
                case "description": {
                    description = parser.getText();
                    break;
                }
                case "dimensions": {
                    dim = MetricsParser.parseDimensions(parser, uniqueDimensions);
                    break;
                }
                case "values": {
                    values = MetricsParser.parseValues(parser);
                    break;
                }
                default: {
                    if (token != JsonToken.START_OBJECT && token != JsonToken.START_ARRAY) break;
                    parser.skipChildren();
                }
            }
            parser.nextToken();
        }
        if (name.isEmpty()) {
            throw new IOException("missing name for entry in 'values' array");
        }
        for (Map.Entry value : values) {
            consumer.accept(new Metric(MetricId.toMetricId(name + "." + (String)value.getKey()), (Number)value.getValue(), timestamp, dim, description));
        }
    }

    private static Map<DimensionId, String> parseDimensions(JsonParser parser, Map<Set<Dimension>, Map<DimensionId, String>> uniqueDimensions) throws IOException {
        HashSet<Dimension> dimensions = new HashSet<Dimension>();
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            if (token == JsonToken.VALUE_STRING) {
                String value = parser.getValueAsString();
                dimensions.add(Dimension.of(fieldName, value));
            } else if (token != JsonToken.VALUE_NULL) {
                throw new IllegalArgumentException("Dimension '" + fieldName + "' must be a string");
            }
            parser.nextToken();
        }
        return uniqueDimensions.computeIfAbsent(dimensions, key -> dimensions.stream().collect(Collectors.toUnmodifiableMap(dim -> DimensionId.toDimensionId(dim.id), dim -> dim.value)));
    }

    private static List<Map.Entry<String, Number>> parseValues(JsonParser parser) throws IOException {
        ArrayList<Map.Entry<String, Number>> metrics = new ArrayList<Map.Entry<String, Number>>();
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            String metricName = fieldName;
            if (token == JsonToken.VALUE_NUMBER_INT) {
                metrics.add(Map.entry(metricName, parser.getLongValue()));
            } else if (token == JsonToken.VALUE_NUMBER_FLOAT) {
                metrics.add(Map.entry(metricName, parser.getValueAsDouble()));
            } else {
                throw new IllegalArgumentException("Value for aggregator '" + fieldName + "' is not a number");
            }
            parser.nextToken();
        }
        return metrics;
    }

    public static interface Collector {
        public void accept(Metric var1);
    }

    record Dimension(String id, String value) {
        static Dimension of(String id, String value) {
            return new Dimension(id, value);
        }
    }
}

