/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.ConfiguredMetric;
import ai.vespa.metricsproxy.core.ConsumersConfig;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import com.yahoo.stream.CustomCollectors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class MetricsConsumers {
    private final Map<ConsumerId, List<ConfiguredMetric>> consumerMetrics;
    private final Map<ConsumerId, Map<MetricId, ConfiguredMetric>> configuredMetricByMetricByConsumer;
    private final Map<ConfiguredMetric, Set<ConsumerId>> consumersByMetric;
    private final Map<MetricId, Map<ConfiguredMetric, Set<ConsumerId>>> consumersByMetricByMetricId;

    public MetricsConsumers(ConsumersConfig config) {
        this.consumerMetrics = config.consumer().stream().collect(MetricsConsumers.toUnmodifiableLinkedMap(consumer -> ConsumerId.toConsumerId(consumer.name()), consumer -> this.convert(consumer.metric())));
        this.configuredMetricByMetricByConsumer = new HashMap<ConsumerId, Map<MetricId, ConfiguredMetric>>();
        this.consumerMetrics.forEach((consumer, configuredList) -> this.configuredMetricByMetricByConsumer.put((ConsumerId)consumer, configuredList.stream().collect(Collectors.toMap(ConfiguredMetric::id, Function.identity()))));
        this.consumersByMetric = MetricsConsumers.createConsumersByMetric(this.consumerMetrics);
        this.consumersByMetricByMetricId = new HashMap<MetricId, Map<ConfiguredMetric, Set<ConsumerId>>>();
        this.consumersByMetric.forEach((configuredMetric, consumers) -> {
            Map consumersByMetric = this.consumersByMetricByMetricId.computeIfAbsent(configuredMetric.id(), id -> new HashMap());
            Set consumerSet = consumersByMetric.computeIfAbsent(configuredMetric, id -> new HashSet());
            consumerSet.addAll(consumers);
        });
    }

    public List<ConfiguredMetric> getMetricDefinitions(ConsumerId consumer) {
        return this.consumerMetrics.get(consumer);
    }

    public Map<ConfiguredMetric, Set<ConsumerId>> getConsumersByMetric() {
        return this.consumersByMetric;
    }

    public Map<ConfiguredMetric, Set<ConsumerId>> getConsumersByMetric(MetricId id) {
        return this.consumersByMetricByMetricId.get(id);
    }

    public Map<MetricId, ConfiguredMetric> getMetricsForConsumer(ConsumerId consumerId) {
        return this.configuredMetricByMetricByConsumer.get(consumerId);
    }

    public Set<ConsumerId> getAllConsumers() {
        return Collections.unmodifiableSet(this.consumerMetrics.keySet());
    }

    private static Map<ConfiguredMetric, Set<ConsumerId>> createConsumersByMetric(Map<ConsumerId, List<ConfiguredMetric>> metricsByConsumer) {
        LinkedHashMap<ConfiguredMetric, Set> consumersByMetric = new LinkedHashMap<ConfiguredMetric, Set>();
        metricsByConsumer.forEach((consumer, metrics) -> metrics.forEach(metric -> consumersByMetric.computeIfAbsent((ConfiguredMetric)metric, unused -> new HashSet()).add(consumer)));
        LinkedHashMap unmodifiableConsumersByMetric = new LinkedHashMap();
        consumersByMetric.forEach((configuredMetric, consumerIds) -> unmodifiableConsumersByMetric.put(configuredMetric, Set.copyOf(consumerIds)));
        return Collections.unmodifiableMap(unmodifiableConsumersByMetric);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toUnmodifiableLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(CustomCollectors.toLinkedMap(keyMapper, valueMapper), Collections::unmodifiableMap);
    }

    private List<ConfiguredMetric> convert(List<ConsumersConfig.Consumer.Metric> configMetrics) {
        ArrayList<ConfiguredMetric> metrics = new ArrayList<ConfiguredMetric>(configMetrics.size());
        configMetrics.forEach(m -> metrics.add(new ConfiguredMetric((ConsumersConfig.Consumer.Metric)((Object)m))));
        return metrics;
    }
}

