/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.metric.model.json.JacksonUtil;
import ai.vespa.metricsproxy.metric.model.json.YamasJsonModel;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class YamasJsonUtil {
    private static final Logger log = Logger.getLogger(YamasJsonUtil.class.getName());
    private static final JsonFactory factory = JsonFactory.builder().enable(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN).build();
    static final String YAMAS_ROUTING = "yamas";

    public static MetricsPacket.Builder toMetricsPacketBuilder(YamasJsonModel jsonModel) {
        if (jsonModel.application == null) {
            throw new IllegalArgumentException("Service id cannot be null");
        }
        return new MetricsPacket.Builder(ServiceId.toServiceId(jsonModel.application)).statusCode(jsonModel.status_code).statusMessage(jsonModel.status_msg).timestamp(jsonModel.timestamp).putMetrics(jsonModel.getMetricsList()).putDimensions(jsonModel.getDimensionsById()).addConsumers(jsonModel.getYamasConsumers());
    }

    public static List<MetricsPacket.Builder> toMetricsPackets(String jsonString) {
        ArrayList<MetricsPacket.Builder> packets = new ArrayList<MetricsPacket.Builder>();
        try {
            JsonParser jp = new JsonFactory().createParser(jsonString);
            jp.setCodec((ObjectCodec)new ObjectMapper());
            while (jp.nextToken() != null) {
                YamasJsonModel jsonModel = (YamasJsonModel)jp.readValueAs(YamasJsonModel.class);
                packets.add(YamasJsonUtil.toMetricsPacketBuilder(jsonModel));
            }
            return packets;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not create metrics packet from string:\n" + jsonString, e);
            return Collections.emptyList();
        }
    }

    public static List<MetricsPacket> appendOptionalStatusPacket(List<MetricsPacket> packets) {
        if (packets.isEmpty()) {
            return packets;
        }
        Set<ConsumerId> consumers = YamasJsonUtil.extractSetForRouting(packets.get(0).consumers());
        if (consumers.isEmpty()) {
            return packets;
        }
        ArrayList<MetricsPacket> withStatus = new ArrayList<MetricsPacket>(packets);
        withStatus.add(new MetricsPacket.Builder(ServiceId.toServiceId("yms_check_vespa")).statusCode(0).statusMessage("Data collected successfully").addConsumers(consumers).build());
        return withStatus;
    }

    public static String toJson(List<MetricsPacket> metrics, boolean addStatus) {
        String string;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            YamasJsonUtil.toJson(metrics, output, addStatus);
            output.flush();
            string = output.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "{}";
            }
        }
        output.close();
        return string;
    }

    private static Set<ConsumerId> extractSetForRouting(Set<ConsumerId> consumers) {
        return consumers.stream().filter(consumerId -> consumerId != ValuesFetcher.defaultMetricsConsumerId).collect(Collectors.toSet());
    }

    public static void toJson(List<MetricsPacket> metrics, OutputStream outputStream, boolean addStatus) throws IOException {
        JsonGenerator generator = factory.createGenerator(outputStream);
        generator.writeStartObject();
        if (metrics.isEmpty()) {
            generator.writeEndObject();
            return;
        }
        generator.writeArrayFieldStart("metrics");
        for (int i = 0; i < metrics.size() - 1; ++i) {
            YamasJsonUtil.toJson(metrics.get(i), generator, addStatus);
        }
        YamasJsonUtil.toJson(metrics.get(metrics.size() - 1), generator, addStatus);
        generator.writeEndArray();
        generator.writeEndObject();
        generator.close();
    }

    private static void toJson(MetricsPacket metric, JsonGenerator generator, boolean addStatus) throws IOException {
        Set<ConsumerId> routing;
        generator.writeStartObject();
        if (addStatus) {
            generator.writeNumberField("status_code", metric.statusCode);
        }
        if (metric.timestamp != 0L) {
            generator.writeNumberField("timestamp", metric.timestamp);
        }
        generator.writeStringField("application", metric.service.id);
        if (!metric.metrics().isEmpty()) {
            generator.writeObjectFieldStart("metrics");
            for (Map.Entry<MetricId, Number> entry : metric.metrics().entrySet()) {
                generator.writeFieldName(entry.getKey().id);
                JacksonUtil.writeDouble(generator, entry.getValue().doubleValue());
            }
            generator.writeEndObject();
        }
        if (!metric.dimensions().isEmpty()) {
            generator.writeObjectFieldStart("dimensions");
            for (Map.Entry<Object, Object> entry : metric.dimensions().entrySet()) {
                generator.writeStringField(((DimensionId)entry.getKey()).id, (String)entry.getValue());
            }
            generator.writeEndObject();
        }
        if (!(routing = YamasJsonUtil.extractSetForRouting(metric.consumers())).isEmpty()) {
            generator.writeObjectFieldStart("routing");
            generator.writeObjectFieldStart(YAMAS_ROUTING);
            generator.writeArrayFieldStart("namespaces");
            for (ConsumerId consumer : routing) {
                generator.writeString(consumer.id);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.writeEndObject();
        }
        if (addStatus) {
            generator.writeStringField("status_msg", metric.statusMessage);
        }
        generator.writeEndObject();
    }
}

