/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.yahoo.stream.CustomCollectors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"status_code", "timestamp", "application", "metrics", "dimensions", "routing", "status_msg"})
public class YamasJsonModel {
    @JsonProperty(value="status_code")
    public Integer status_code;
    @JsonProperty(value="status_msg")
    public String status_msg;
    @JsonProperty(value="timestamp")
    public Long timestamp;
    @JsonProperty(value="application")
    public String application;
    @JsonProperty(value="metrics")
    public Map<String, Double> metrics;
    @JsonProperty(value="dimensions")
    public Map<String, String> dimensions;
    @JsonProperty(value="routing")
    public Map<String, YamasJsonNamespace> routing;

    public void resetMetrics(List<Metric> newMetrics) {
        this.metrics = new LinkedHashMap<String, Double>();
        newMetrics.forEach(metric -> this.metrics.put(metric.getName(), metric.getValue().doubleValue()));
    }

    public void addRouting(Set<ConsumerId> names) {
        if (this.routing == null) {
            this.routing = new HashMap<String, YamasJsonNamespace>();
        }
        if (!this.routing.containsKey("yamas")) {
            this.routing.put("yamas", new YamasJsonNamespace());
        }
        YamasJsonNamespace namespace = this.routing.get("yamas");
        if (namespace.namespaces == null) {
            namespace.namespaces = new ArrayList<String>();
        }
        namespace.namespaces.addAll(names.stream().map(consumer -> consumer.id).collect(Collectors.toList()));
    }

    public void addDimensions(Map<DimensionId, String> additionalDimensions, boolean replace) {
        additionalDimensions.forEach((k, v) -> this.addDimension(k.id, (String)v, replace));
    }

    public void addDimension(String key, String value, boolean replace) {
        if (this.dimensions == null) {
            this.dimensions = new HashMap<String, String>();
        }
        if (!this.dimensions.containsKey(key) || replace) {
            this.dimensions.put(key, value);
        }
    }

    List<Metric> getMetricsList() {
        if (this.metrics == null) {
            return Collections.emptyList();
        }
        return this.metrics.keySet().stream().map(name -> new Metric((String)name, this.metrics.get(name))).collect(Collectors.toList());
    }

    Map<DimensionId, String> getDimensionsById() {
        if (this.dimensions == null) {
            return Collections.emptyMap();
        }
        return (Map)this.dimensions.keySet().stream().collect(CustomCollectors.toLinkedMap(DimensionId::toDimensionId, name -> this.dimensions.get(name)));
    }

    Set<ConsumerId> getYamasConsumers() {
        if (this.routing == null || this.routing.get("yamas") == null) {
            return Collections.emptySet();
        }
        return this.routing.get((Object)"yamas").namespaces.stream().map(ConsumerId::toConsumerId).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static class YamasJsonNamespace {
        @JsonProperty(value="namespaces")
        public List<String> namespaces;
    }
}

