/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.rpc;

import ai.vespa.metricsproxy.rpc.RpcConnectorConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.log.LogLevel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcConnector
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(RpcConnector.class.getName());
    private final Supervisor supervisor = new Supervisor(new Transport());
    private final Acceptor acceptor;

    public RpcConnector(RpcConnectorConfig config) {
        Spec spec = new Spec(config.port());
        try {
            this.acceptor = this.supervisor.listen(spec);
            log.log((Level)LogLevel.DEBUG, "Listening on " + spec.host() + ":" + this.acceptor.port());
        }
        catch (ListenFailedException e) {
            this.stop();
            log.log(Level.INFO, "Failed listening at " + spec.host() + ":" + spec.port());
            throw new RuntimeException("Could not listen at " + spec, e);
        }
    }

    public int port() {
        return this.acceptor.port();
    }

    public void addMethod(Method method) {
        this.supervisor.addMethod(method);
    }

    public void stop() {
        this.acceptor.shutdown().join();
        this.supervisor.transport().shutdown().join();
    }

    public void deconstruct() {
        this.stop();
        super.deconstruct();
    }
}

