/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.VespaService;
import com.yahoo.log.LogLevel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteHealthMetricFetcher
extends HttpMetricFetcher {
    private static final Logger log = Logger.getLogger(RemoteHealthMetricFetcher.class.getPackage().getName());

    public RemoteHealthMetricFetcher(VespaService service, int port) {
        super(service, port, "/state/v1/health");
    }

    public HealthMetric getHealth(int fetchCount) {
        String data = "{}";
        try {
            data = this.getJson();
        }
        catch (IOException e) {
            this.logMessageNoResponse(this.errMsgNoResponse(e), fetchCount);
        }
        return this.createHealthMetrics(data, fetchCount);
    }

    HealthMetric createHealthMetrics(String data, int fetchCount) {
        HealthMetric healthMetric = HealthMetric.getFailed("Failed fetching status page for service");
        try {
            healthMetric = this.parse(data);
        }
        catch (Exception e) {
            this.handleException(e, data, fetchCount);
        }
        return healthMetric;
    }

    private HealthMetric parse(String data) {
        if (data == null || data.isEmpty()) {
            return HealthMetric.getFailed("Empty response from status page");
        }
        try {
            JSONObject o = new JSONObject(data);
            JSONObject status = o.getJSONObject("status");
            String code = status.getString("code");
            String message = "";
            if (status.has("message")) {
                message = status.getString("message");
            }
            return HealthMetric.get(code, message);
        }
        catch (JSONException e) {
            log.log((Level)LogLevel.DEBUG, "Failed to parse json response from metrics page:" + e + ":" + data);
            return HealthMetric.getFailed("Not able to parse json from status page");
        }
    }
}

