/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.ConsumersConfig;
import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.metric.AggregationKey;
import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.Metrics;
import ai.vespa.metricsproxy.metric.MetricsFormatter;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.metricsproxy.service.VespaServices;
import com.google.common.base.Strings;
import com.yahoo.log.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class VespaMetrics {
    private static final Logger log = Logger.getLogger(VespaMetrics.class.getPackage().getName());
    public static final ConsumerId VESPA_CONSUMER_ID = ConsumerId.toConsumerId("Vespa");
    public static final DimensionId METRIC_TYPE_DIMENSION_ID = DimensionId.toDimensionId("metrictype");
    public static final DimensionId INSTANCE_DIMENSION_ID = DimensionId.toDimensionId("instance");
    private static final Set<ConsumerId> DEFAULT_CONSUMERS = Collections.singleton(VESPA_CONSUMER_ID);
    private final MetricsConsumers metricsConsumers;
    private static final MetricsFormatter formatter = new MetricsFormatter(false, false);

    public VespaMetrics(MetricsConsumers metricsConsumers, VespaServices vespaServices) {
        this.metricsConsumers = metricsConsumers;
    }

    public List<MetricsPacket> getHealthMetrics(List<VespaService> services) {
        ArrayList<MetricsPacket> result = new ArrayList<MetricsPacket>();
        for (VespaService s : services) {
            HealthMetric h = s.getHealth();
            MetricsPacket.Builder builder = new MetricsPacket.Builder(ServiceId.toServiceId(s.getMonitoringName())).statusCode(h.isOk() ? 0 : 1).statusMessage(h.getMessage()).putDimension(METRIC_TYPE_DIMENSION_ID, "health").putDimension(INSTANCE_DIMENSION_ID, s.getInstanceName());
            result.add(builder.build());
        }
        return result;
    }

    public List<MetricsPacket.Builder> getMetrics(List<VespaService> services) {
        ArrayList<MetricsPacket.Builder> metricsPackets = new ArrayList<MetricsPacket.Builder>();
        log.log((Level)LogLevel.DEBUG, () -> "Updating services prior to fetching metrics, number of services= " + services.size());
        Map<ConsumersConfig.Consumer.Metric, List<ConsumerId>> consumersByMetric = this.metricsConsumers.getConsumersByMetric();
        for (VespaService service : services) {
            Optional<MetricsPacket.Builder> systemCheck = this.getSystemMetrics(service);
            systemCheck.ifPresent(metricsPackets::add);
            Metrics serviceMetrics = this.getServiceMetrics(service, consumersByMetric);
            Map<AggregationKey, List<Metric>> aggregatedMetrics = this.aggregateMetrics(service.getDimensions(), serviceMetrics);
            aggregatedMetrics.forEach((aggregationKey, metrics) -> {
                MetricsPacket.Builder builder = new MetricsPacket.Builder(ServiceId.toServiceId(service.getMonitoringName())).putMetrics((Collection<Metric>)metrics).putDimension(METRIC_TYPE_DIMENSION_ID, "standard").putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).putDimensions(aggregationKey.getDimensions());
                VespaMetrics.setMetaInfo(builder, serviceMetrics.getTimeStamp());
                builder.addConsumers(aggregationKey.getConsumers());
                metricsPackets.add(builder);
            });
        }
        return metricsPackets;
    }

    private Metrics getServiceMetrics(VespaService service, Map<ConsumersConfig.Consumer.Metric, List<ConsumerId>> consumersByMetric) {
        Metrics serviceMetrics = new Metrics();
        Metrics allServiceMetrics = service.getMetrics();
        serviceMetrics.setTimeStamp(this.getMostRecentTimestamp(allServiceMetrics));
        for (Metric candidate : allServiceMetrics.getMetrics()) {
            VespaMetrics.getConfiguredMetrics(candidate.getName(), consumersByMetric.keySet()).forEach(configuredMetric -> serviceMetrics.add(this.metricWithConfigProperties(candidate, (ConsumersConfig.Consumer.Metric)((Object)configuredMetric), consumersByMetric)));
        }
        return serviceMetrics;
    }

    private Map<DimensionId, String> extractDimensions(Map<DimensionId, String> dimensions, List<ConsumersConfig.Consumer.Metric.Dimension> configuredDimensions) {
        if (!configuredDimensions.isEmpty()) {
            HashMap<DimensionId, String> dims = new HashMap<DimensionId, String>(dimensions);
            configuredDimensions.forEach(d -> dims.put(DimensionId.toDimensionId(d.key()), d.value()));
            dimensions = Collections.unmodifiableMap(dims);
        }
        return dimensions;
    }

    private Set<ConsumerId> extractConsumers(List<ConsumerId> configuredConsumers) {
        Set<ConsumerId> consumers = Collections.emptySet();
        if (configuredConsumers != null) {
            if (configuredConsumers.size() == 1) {
                consumers = Collections.singleton(configuredConsumers.get(0));
            } else if (configuredConsumers.size() > 1) {
                consumers = new HashSet<ConsumerId>();
                consumers.addAll(configuredConsumers);
                consumers = Collections.unmodifiableSet(consumers);
            }
        }
        return consumers;
    }

    private Metric metricWithConfigProperties(Metric candidate, ConsumersConfig.Consumer.Metric configuredMetric, Map<ConsumersConfig.Consumer.Metric, List<ConsumerId>> consumersByMetric) {
        Metric metric = candidate.clone();
        metric.setDimensions(this.extractDimensions(candidate.getDimensions(), configuredMetric.dimension()));
        metric.setConsumers(this.extractConsumers(consumersByMetric.get((Object)configuredMetric)));
        if (!Strings.isNullOrEmpty((String)configuredMetric.outputname())) {
            metric.setName(configuredMetric.outputname());
        }
        return metric;
    }

    private static Set<ConsumersConfig.Consumer.Metric> getConfiguredMetrics(String id, Set<ConsumersConfig.Consumer.Metric> configuredMetrics) {
        return configuredMetrics.stream().filter(m -> m.name().equals(id)).collect(Collectors.toSet());
    }

    private Optional<MetricsPacket.Builder> getSystemMetrics(VespaService service) {
        Metrics systemMetrics = service.getSystemMetrics();
        if (systemMetrics.size() == 0) {
            return Optional.empty();
        }
        MetricsPacket.Builder builder = new MetricsPacket.Builder(ServiceId.toServiceId(service.getMonitoringName()));
        VespaMetrics.setMetaInfo(builder, systemMetrics.getTimeStamp());
        builder.putDimension(METRIC_TYPE_DIMENSION_ID, "system").putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).putDimensions(service.getDimensions()).putMetrics(systemMetrics.getMetrics());
        builder.addConsumers(this.metricsConsumers.getAllConsumers());
        return Optional.of(builder);
    }

    private long getMostRecentTimestamp(Metrics metrics) {
        long mostRecentTimestamp = 0L;
        for (Metric metric : metrics.getMetrics()) {
            if (metric.getTimeStamp() <= mostRecentTimestamp) continue;
            mostRecentTimestamp = metric.getTimeStamp();
        }
        return mostRecentTimestamp;
    }

    private Map<AggregationKey, List<Metric>> aggregateMetrics(Map<DimensionId, String> serviceDimensions, Metrics metrics) {
        HashMap<AggregationKey, List<Metric>> aggregatedMetrics = new HashMap<AggregationKey, List<Metric>>();
        for (Metric metric : metrics.getMetrics()) {
            LinkedHashMap<DimensionId, String> mergedDimensions = new LinkedHashMap<DimensionId, String>();
            mergedDimensions.putAll(metric.getDimensions());
            mergedDimensions.putAll(serviceDimensions);
            AggregationKey aggregationKey = new AggregationKey(mergedDimensions, metric.getConsumers());
            if (aggregatedMetrics.containsKey(aggregationKey)) {
                ((List)aggregatedMetrics.get(aggregationKey)).add(metric);
                continue;
            }
            ArrayList<Metric> ml = new ArrayList<Metric>();
            ml.add(metric);
            aggregatedMetrics.put(aggregationKey, ml);
        }
        return aggregatedMetrics;
    }

    private List<ConsumersConfig.Consumer.Metric> getMetricDefinitions(ConsumerId consumer) {
        if (this.metricsConsumers == null) {
            return Collections.emptyList();
        }
        List<ConsumersConfig.Consumer.Metric> definitions = this.metricsConsumers.getMetricDefinitions(consumer);
        return definitions == null ? Collections.emptyList() : definitions;
    }

    private static void setMetaInfo(MetricsPacket.Builder builder, long timestamp) {
        builder.timestamp(timestamp).statusCode(0).statusMessage("Data collected successfully");
    }

    public String getMetricsAsString(List<VespaService> services) {
        StringBuilder b = new StringBuilder();
        for (VespaService s : services) {
            for (Metric metric : s.getMetrics().getMetrics()) {
                String key;
                String alias = key = metric.getName();
                boolean isForwarded = false;
                for (ConsumersConfig.Consumer.Metric metricConsumer : this.getMetricDefinitions(VESPA_CONSUMER_ID)) {
                    if (!metricConsumer.name().equals(key)) continue;
                    alias = metricConsumer.outputname();
                    isForwarded = true;
                }
                if (!isForwarded) continue;
                b.append(formatter.format(s, alias, metric.getValue())).append(" ");
            }
        }
        return b.toString();
    }

    public String getMetricNames(List<VespaService> services, ConsumerId consumer) {
        StringBuilder bufferOn = new StringBuilder();
        StringBuilder bufferOff = new StringBuilder();
        for (VespaService s : services) {
            for (Metric m : s.getMetrics().getMetrics()) {
                String description = m.getDescription();
                String alias = "";
                boolean isForwarded = false;
                for (ConsumersConfig.Consumer.Metric metric : this.getMetricDefinitions(consumer)) {
                    if (!metric.name().equals(m.getName())) continue;
                    alias = metric.outputname();
                    isForwarded = true;
                    if (!description.isEmpty()) continue;
                    description = metric.description();
                }
                String message = "OFF";
                StringBuilder buffer = bufferOff;
                if (isForwarded) {
                    buffer = bufferOn;
                    message = "ON";
                }
                buffer.append(m.getName()).append('=').append(message);
                if (!description.isEmpty()) {
                    buffer.append(";description=").append(description);
                }
                if (!alias.isEmpty()) {
                    buffer.append(";output-name=").append(alias);
                }
                buffer.append(',');
            }
        }
        return bufferOn.toString() + bufferOff.toString();
    }
}

