/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.http.application.MetricsNodesConfig;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import java.net.URI;
import java.util.Objects;

public class Node {
    public final String role;
    public final String hostname;
    private final int port;
    private final String path;
    private final String metricsUriBase;

    public Node(MetricsNodesConfig.Node nodeConfig) {
        this(nodeConfig.role(), nodeConfig.hostname(), nodeConfig.metricsPort(), nodeConfig.metricsPath());
    }

    public Node(String role, String hostname, int port, String path) {
        Objects.requireNonNull(role, "Null role is not allowed");
        Objects.requireNonNull(hostname, "Null hostname is not allowed");
        Objects.requireNonNull(path, "Null path is not allowed");
        this.role = role;
        this.hostname = hostname;
        this.port = port;
        this.path = path;
        this.metricsUriBase = "http://" + hostname + ":" + port + path;
    }

    URI metricsUri(ConsumerId consumer) {
        return URI.create(this.metricsUriBase + "?consumer=" + consumer.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.port == node.port && this.path.equals(node.path) && this.role.equals(node.role) && this.hostname.equals(node.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.hostname, this.port, this.path);
    }
}

