/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.ConfiguredMetric;
import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.metric.AggregationKey;
import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.Metrics;
import ai.vespa.metricsproxy.metric.MetricsFormatter;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.Dimension;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.service.VespaService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class VespaMetrics {
    public static final ConsumerId vespaMetricsConsumerId = ConsumerId.toConsumerId("Vespa");
    public static final DimensionId METRIC_TYPE_DIMENSION_ID = DimensionId.toDimensionId("metrictype");
    public static final DimensionId INSTANCE_DIMENSION_ID = DimensionId.toDimensionId("instance");
    private final MetricsConsumers metricsConsumers;
    private static final MetricsFormatter formatter = new MetricsFormatter(false, false);

    public VespaMetrics(MetricsConsumers metricsConsumers) {
        this.metricsConsumers = metricsConsumers;
    }

    public List<MetricsPacket> getHealthMetrics(List<VespaService> services) {
        ArrayList<MetricsPacket> result = new ArrayList<MetricsPacket>();
        for (VespaService s : services) {
            HealthMetric h = s.getHealth();
            MetricsPacket.Builder builder = new MetricsPacket.Builder(s.getMonitoringName()).statusCode(h.isOk() ? 0 : 1).statusMessage(h.getMessage()).putDimension(METRIC_TYPE_DIMENSION_ID, "health").putDimension(INSTANCE_DIMENSION_ID, s.getInstanceName());
            result.add(builder.build());
        }
        return result;
    }

    public List<MetricsPacket.Builder> getMetrics(List<VespaService> services) {
        ArrayList<MetricsPacket.Builder> metricsPackets = new ArrayList<MetricsPacket.Builder>();
        Map<ConfiguredMetric, List<ConsumerId>> consumersByMetric = this.metricsConsumers.getConsumersByMetric();
        for (VespaService service : services) {
            Optional<MetricsPacket.Builder> systemCheck = this.getSystemMetrics(service);
            systemCheck.ifPresent(metricsPackets::add);
            Metrics allServiceMetrics = service.getMetrics();
            if (!allServiceMetrics.getMetrics().isEmpty()) {
                Metrics serviceMetrics = this.getServiceMetrics(allServiceMetrics, consumersByMetric);
                Map<AggregationKey, List<Metric>> aggregatedMetrics = this.aggregateMetrics(service.getDimensions(), serviceMetrics);
                aggregatedMetrics.forEach((aggregationKey, metrics) -> {
                    MetricsPacket.Builder builder = new MetricsPacket.Builder(service.getMonitoringName()).putMetrics((Collection<Metric>)metrics).putDimension(METRIC_TYPE_DIMENSION_ID, "standard").putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).putDimensions(aggregationKey.getDimensions());
                    VespaMetrics.setMetaInfo(builder, serviceMetrics.getTimeStamp());
                    builder.addConsumers(aggregationKey.getConsumers());
                    metricsPackets.add(builder);
                });
                continue;
            }
            metricsPackets.add(this.getHealth(service));
        }
        return metricsPackets;
    }

    private MetricsPacket.Builder getHealth(VespaService service) {
        HealthMetric health = service.getHealth();
        return new MetricsPacket.Builder(service.getMonitoringName()).timestamp(System.currentTimeMillis() / 1000L).statusCode(health.getStatus().ordinal()).statusMessage(health.getMessage()).putDimensions(service.getDimensions()).putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).addConsumers(this.metricsConsumers.getAllConsumers());
    }

    private Metrics getServiceMetrics(Metrics allServiceMetrics, Map<ConfiguredMetric, List<ConsumerId>> consumersByMetric) {
        Metrics configuredServiceMetrics = new Metrics();
        configuredServiceMetrics.setTimeStamp(this.getMostRecentTimestamp(allServiceMetrics));
        for (Metric candidate : allServiceMetrics.getMetrics()) {
            VespaMetrics.getConfiguredMetrics(candidate.getName(), consumersByMetric.keySet()).forEach(configuredMetric -> configuredServiceMetrics.add(this.metricWithConfigProperties(candidate, (ConfiguredMetric)configuredMetric, consumersByMetric)));
        }
        return configuredServiceMetrics;
    }

    private Map<DimensionId, String> extractDimensions(Map<DimensionId, String> dimensions, List<Dimension> configuredDimensions) {
        if (!configuredDimensions.isEmpty()) {
            HashMap<DimensionId, String> dims = new HashMap<DimensionId, String>(dimensions);
            configuredDimensions.forEach(d -> dims.put(d.key(), d.value()));
            dimensions = Collections.unmodifiableMap(dims);
        }
        return dimensions;
    }

    private Set<ConsumerId> extractConsumers(List<ConsumerId> configuredConsumers) {
        Set<ConsumerId> consumers = Collections.emptySet();
        if (configuredConsumers != null) {
            if (configuredConsumers.size() == 1) {
                consumers = Collections.singleton(configuredConsumers.get(0));
            } else if (configuredConsumers.size() > 1) {
                consumers = Set.copyOf(configuredConsumers);
            }
        }
        return consumers;
    }

    private Metric metricWithConfigProperties(Metric candidate, ConfiguredMetric configuredMetric, Map<ConfiguredMetric, List<ConsumerId>> consumersByMetric) {
        Metric metric = candidate.clone();
        metric.setDimensions(this.extractDimensions(candidate.getDimensions(), configuredMetric.dimension()));
        metric.setConsumers(this.extractConsumers(consumersByMetric.get(configuredMetric)));
        if (configuredMetric.outputname() != null && !configuredMetric.outputname().id.isEmpty()) {
            metric.setName(configuredMetric.outputname());
        }
        return metric;
    }

    private static Set<ConfiguredMetric> getConfiguredMetrics(MetricId id, Set<ConfiguredMetric> configuredMetrics) {
        return configuredMetrics.stream().filter(m -> m.id().equals(id)).collect(Collectors.toSet());
    }

    private Optional<MetricsPacket.Builder> getSystemMetrics(VespaService service) {
        Metrics systemMetrics = service.getSystemMetrics();
        if (systemMetrics.size() == 0) {
            return Optional.empty();
        }
        MetricsPacket.Builder builder = new MetricsPacket.Builder(service.getMonitoringName());
        VespaMetrics.setMetaInfo(builder, systemMetrics.getTimeStamp());
        builder.putDimension(METRIC_TYPE_DIMENSION_ID, "system").putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).putDimensions(service.getDimensions()).putMetrics(systemMetrics.getMetrics());
        builder.addConsumers(this.metricsConsumers.getAllConsumers());
        return Optional.of(builder);
    }

    private long getMostRecentTimestamp(Metrics metrics) {
        long mostRecentTimestamp = 0L;
        for (Metric metric : metrics.getMetrics()) {
            if (metric.getTimeStamp() <= mostRecentTimestamp) continue;
            mostRecentTimestamp = metric.getTimeStamp();
        }
        return mostRecentTimestamp;
    }

    private Map<AggregationKey, List<Metric>> aggregateMetrics(Map<DimensionId, String> serviceDimensions, Metrics metrics) {
        HashMap<AggregationKey, List<Metric>> aggregatedMetrics = new HashMap<AggregationKey, List<Metric>>();
        for (Metric metric : metrics.getMetrics()) {
            LinkedHashMap<DimensionId, String> mergedDimensions = new LinkedHashMap<DimensionId, String>();
            mergedDimensions.putAll(metric.getDimensions());
            mergedDimensions.putAll(serviceDimensions);
            AggregationKey aggregationKey = new AggregationKey(mergedDimensions, metric.getConsumers());
            if (aggregatedMetrics.containsKey(aggregationKey)) {
                ((List)aggregatedMetrics.get(aggregationKey)).add(metric);
                continue;
            }
            ArrayList<Metric> ml = new ArrayList<Metric>();
            ml.add(metric);
            aggregatedMetrics.put(aggregationKey, ml);
        }
        return aggregatedMetrics;
    }

    private List<ConfiguredMetric> getMetricDefinitions(ConsumerId consumer) {
        if (this.metricsConsumers == null) {
            return Collections.emptyList();
        }
        List<ConfiguredMetric> definitions = this.metricsConsumers.getMetricDefinitions(consumer);
        return definitions == null ? Collections.emptyList() : definitions;
    }

    private static void setMetaInfo(MetricsPacket.Builder builder, long timestamp) {
        builder.timestamp(timestamp).statusCode(0).statusMessage("Data collected successfully");
    }

    public String getMetricsAsString(List<VespaService> services) {
        StringBuilder b = new StringBuilder();
        for (VespaService s : services) {
            for (Metric metric : s.getMetrics().getMetrics()) {
                MetricId key;
                MetricId alias = key = metric.getName();
                boolean isForwarded = false;
                for (ConfiguredMetric metricConsumer : this.getMetricDefinitions(vespaMetricsConsumerId)) {
                    if (!metricConsumer.id().equals(key)) continue;
                    alias = metricConsumer.outputname();
                    isForwarded = true;
                }
                if (!isForwarded) continue;
                b.append(formatter.format(s, alias.id, metric.getValue())).append(" ");
            }
        }
        return b.toString();
    }

    public String getMetricNames(List<VespaService> services, ConsumerId consumer) {
        StringBuilder bufferOn = new StringBuilder();
        StringBuilder bufferOff = new StringBuilder();
        for (VespaService s : services) {
            for (Metric m : s.getMetrics().getMetrics()) {
                String description = m.getDescription();
                MetricId alias = MetricId.empty;
                boolean isForwarded = false;
                for (ConfiguredMetric metric : this.getMetricDefinitions(consumer)) {
                    if (!metric.id().equals(m.getName())) continue;
                    alias = metric.outputname();
                    isForwarded = true;
                    if (!description.isEmpty()) continue;
                    description = metric.description();
                }
                String message = "OFF";
                StringBuilder buffer = bufferOff;
                if (isForwarded) {
                    buffer = bufferOn;
                    message = "ON";
                }
                buffer.append(m.getName()).append('=').append(message);
                if (!description.isEmpty()) {
                    buffer.append(";description=").append(description);
                }
                if (!alias.id.isEmpty()) {
                    buffer.append(";output-name=").append(alias);
                }
                buffer.append(',');
            }
        }
        return bufferOn.append((CharSequence)bufferOff).toString();
    }
}

