/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.metrics;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.http.application.ClusterIdDimensionProcessor;
import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.http.application.PublicDimensionsProcessor;
import ai.vespa.metricsproxy.http.application.ServiceIdDimensionProcessor;
import ai.vespa.metricsproxy.http.metrics.NodeInfoConfig;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonUtil;
import ai.vespa.metricsproxy.metric.model.processing.MetricsProcessor;
import ai.vespa.metricsproxy.service.VespaServices;
import com.google.inject.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.handler.metrics.JsonResponse;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class MetricsV2Handler
extends HttpHandlerBase {
    public static final String V2_PATH = "/metrics/v2";
    public static final String VALUES_PATH = "/metrics/v2/values";
    private static final int MAX_DIMENSIONS = 10;
    private final ValuesFetcher valuesFetcher;
    private final NodeInfoConfig nodeInfoConfig;

    @Inject
    public MetricsV2Handler(Executor executor, MetricsManager metricsManager, VespaServices vespaServices, MetricsConsumers metricsConsumers, NodeInfoConfig nodeInfoConfig) {
        super(executor);
        this.nodeInfoConfig = nodeInfoConfig;
        this.valuesFetcher = new ValuesFetcher(metricsManager, vespaServices, metricsConsumers);
    }

    public Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V2_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private JsonResponse valuesResponse(String consumer) {
        try {
            List<MetricsPacket.Builder> builders = this.valuesFetcher.fetchMetricsAsBuilders(consumer);
            List<MetricsPacket> metrics = MetricsV2Handler.processAndBuild(builders, new ServiceIdDimensionProcessor(), new ClusterIdDimensionProcessor(), new PublicDimensionsProcessor(10));
            Node localNode = new Node(this.nodeInfoConfig.role(), this.nodeInfoConfig.hostname(), 0, "");
            Map<Node, List<MetricsPacket>> metricsByNode = Collections.singletonMap(localNode, metrics);
            return new JsonResponse(200, GenericJsonUtil.toGenericApplicationModel(metricsByNode).serialize());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Got exception when rendering metrics:", e);
            return new ErrorResponse(500, e.getMessage());
        }
    }

    private static List<MetricsPacket> processAndBuild(List<MetricsPacket.Builder> builders, MetricsProcessor ... processors) {
        return builders.stream().map(builder -> MetricsProcessor.applyProcessors(builder, processors)).map(MetricsPacket.Builder::build).collect(Collectors.toList());
    }
}

