/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MonitoringConfig;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.service.ConfigSentinelClient;
import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.metricsproxy.service.VespaServicesConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VespaServices {
    private static final Logger log = Logger.getLogger(VespaServices.class.getName());
    public static final String ALL_SERVICES = "all";
    private final ConfigSentinelClient sentinel;
    private final List<VespaService> services;

    @Inject
    public VespaServices(VespaServicesConfig config, MonitoringConfig monitoringConfig, ConfigSentinelClient sentinel) {
        this.sentinel = sentinel;
        this.services = this.createServices(config, monitoringConfig.systemName());
        this.updateServices(this.services);
    }

    @VisibleForTesting
    public VespaServices(List<VespaService> services) {
        this.services = services;
        this.sentinel = null;
    }

    private List<VespaService> createServices(VespaServicesConfig servicesConfig, String monitoringSystemName) {
        ArrayList<VespaService> services = new ArrayList<VespaService>();
        for (VespaServicesConfig.Service s : servicesConfig.service()) {
            log.log(Level.FINE, "Creating service " + s.name());
            VespaService vespaService = VespaService.create(s.name(), s.configId(), s.port(), monitoringSystemName, VespaServices.createServiceDimensions(s));
            services.add(vespaService);
        }
        log.log(Level.FINE, "Created new services: " + services.size());
        return services;
    }

    public final void updateServices(List<VespaService> services) {
        if (this.sentinel != null) {
            log.log(Level.FINE, "Updating services ");
            this.sentinel.updateServiceStatuses(services);
        }
    }

    public List<VespaService> getVespaServices() {
        return Collections.unmodifiableList(this.services);
    }

    public List<VespaService> getInstancesById(String id) {
        ArrayList<VespaService> myServices = new ArrayList<VespaService>();
        for (VespaService s : this.services) {
            if (!s.getConfigId().equals(id)) continue;
            myServices.add(s);
        }
        return myServices;
    }

    public List<VespaService> getMonitoringServices(String service) {
        if (service.equalsIgnoreCase(ALL_SERVICES)) {
            return this.services;
        }
        ArrayList<VespaService> myServices = new ArrayList<VespaService>();
        for (VespaService s : this.services) {
            log.log(Level.FINE, () -> "getMonitoringServices. service=" + service + ", checking against " + s + ", which has monitoring name " + s.getMonitoringName());
            if (!s.getMonitoringName().equalsIgnoreCase(service)) continue;
            myServices.add(s);
        }
        return myServices;
    }

    private static Map<DimensionId, String> createServiceDimensions(VespaServicesConfig.Service service) {
        return service.dimension().stream().collect(MetricsConsumers.toUnmodifiableLinkedMap(dim -> DimensionId.toDimensionId(dim.key()), VespaServicesConfig.Service.Dimension::value));
    }
}

