/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.Metrics;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.VespaService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RemoteMetricsFetcher
extends HttpMetricFetcher {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    static final String METRICS_PATH = "/state/v1/metrics";

    RemoteMetricsFetcher(VespaService service, int port) {
        super(service, port, METRICS_PATH);
    }

    public Metrics getMetrics(int fetchCount) {
        String data = "{}";
        try {
            data = this.getJson();
        }
        catch (IOException e) {
            this.logMessageNoResponse(this.errMsgNoResponse(e), fetchCount);
        }
        return this.createMetrics(data, fetchCount);
    }

    Metrics createMetrics(String data, int fetchCount) {
        Metrics remoteMetrics = new Metrics();
        try {
            remoteMetrics = this.parse(data);
        }
        catch (Exception e) {
            this.handleException(e, data, fetchCount);
        }
        return remoteMetrics;
    }

    private Metrics parse(String data) throws IOException {
        ArrayNode values;
        long timestamp;
        JsonNode o = jsonMapper.readTree(data);
        if (!o.has("metrics")) {
            return new Metrics();
        }
        JsonNode metrics = o.get("metrics");
        try {
            JsonNode snapshot = metrics.get("snapshot");
            timestamp = snapshot.get("to").asLong();
            values = (ArrayNode)metrics.get("values");
        }
        catch (Exception e) {
            return new Metrics();
        }
        long now = System.currentTimeMillis() / 1000L;
        timestamp = Metric.adjustTime(timestamp, now);
        Metrics m = new Metrics(timestamp);
        Map noDims = Collections.emptyMap();
        HashMap uniqueDimensions = new HashMap();
        for (int i = 0; i < values.size(); ++i) {
            JsonNode metric = values.get(i);
            String name = metric.get("name").textValue();
            String description = "";
            if (metric.has("description")) {
                description = metric.get("description").textValue();
            }
            Map dim = noDims;
            if (metric.has("dimensions")) {
                String v;
                String k;
                JsonNode dimensions = metric.get("dimensions");
                StringBuilder sb = new StringBuilder();
                Iterator it = dimensions.fieldNames();
                while (it.hasNext()) {
                    k = (String)it.next();
                    v = dimensions.get(k).asText();
                    sb.append(DimensionId.toDimensionId(k)).append(v);
                }
                if (!uniqueDimensions.containsKey(sb.toString())) {
                    dim = new HashMap();
                    it = dimensions.fieldNames();
                    while (it.hasNext()) {
                        k = (String)it.next();
                        v = dimensions.get(k).textValue();
                        dim.put(DimensionId.toDimensionId(k), v);
                    }
                    uniqueDimensions.put(sb.toString(), Collections.unmodifiableMap(dim));
                }
                dim = (Map)uniqueDimensions.get(sb.toString());
            }
            JsonNode aggregates = metric.get("values");
            Iterator it = aggregates.fieldNames();
            while (it.hasNext()) {
                String aggregator = (String)it.next();
                JsonNode aggregatorValue = aggregates.get(aggregator);
                if (aggregatorValue == null) {
                    throw new IllegalArgumentException("Value for aggregator '" + aggregator + "' is missing");
                }
                Number value = aggregatorValue.numberValue();
                if (value == null) {
                    throw new IllegalArgumentException("Value for aggregator '" + aggregator + "' is not a number");
                }
                StringBuilder metricName = new StringBuilder().append(name).append(".").append(aggregator);
                m.add(new Metric(metricName.toString(), value, timestamp, dim, description));
            }
        }
        return m;
    }
}

