/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.util.http.VespaHttpClientBuilder;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class HttpMetricFetcher {
    private static final Logger log = Logger.getLogger(HttpMetricFetcher.class.getPackage().getName());
    public static final String STATE_PATH = "/state/v1/";
    public static int CONNECTION_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 60000;
    private final URI url;
    protected final VespaService service;
    private static final CloseableHttpClient httpClient = HttpMetricFetcher.createHttpClient();

    HttpMetricFetcher(VespaService service, int port, String path) {
        this.service = service;
        String u = "http://localhost:" + port + path;
        this.url = URI.create(u);
        log.log(Level.FINE, "Fetching metrics from " + u + " with timeout " + CONNECTION_TIMEOUT);
    }

    String getJson() throws IOException {
        log.log(Level.FINE, "Connecting to url " + this.url + " for service '" + this.service + "'");
        return (String)httpClient.execute((HttpUriRequest)new HttpGet(this.url), (ResponseHandler)new BasicResponseHandler());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " using " + this.url;
    }

    String errMsgNoResponse(IOException e) {
        return "Unable to get response from service '" + this.service + "': " + Exceptions.toMessageString((Throwable)e);
    }

    void handleException(Exception e, String data, int timesFetched) {
        this.logMessage("Unable to parse json '" + data + "' for service '" + this.service + "': " + Exceptions.toMessageString((Throwable)e), timesFetched);
    }

    private void logMessage(String message, int timesFetched) {
        if (this.service.isAlive() && timesFetched > 5) {
            log.log(Level.INFO, message);
        } else {
            log.log(Level.FINE, message);
        }
    }

    void logMessageNoResponse(String message, int timesFetched) {
        if (timesFetched > 5) {
            log.log(Level.WARNING, message);
        } else {
            log.log(Level.INFO, message);
        }
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.create().setUserAgent("metrics-proxy-http-client").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(CONNECTION_TIMEOUT).setSocketTimeout(60000).build()).build();
    }
}

