/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.telegraf;

import ai.vespa.metricsproxy.telegraf.TelegrafConfig;
import ai.vespa.metricsproxy.telegraf.TelegrafRegistry;
import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.system.execution.ProcessExecutor;
import com.yahoo.system.execution.ProcessResult;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.yolean.Exceptions;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class Telegraf
extends AbstractComponent {
    private static final String TELEGRAF_CONFIG_PATH = Defaults.getDefaults().underVespaHome("conf/telegraf/telegraf.conf");
    private static final String TELEGRAF_LOG_FILE_PATH = Defaults.getDefaults().underVespaHome("logs/telegraf/telegraf.log");
    private static final String START_TELEGRAF_SCRIPT = Defaults.getDefaults().underVespaHome("libexec/vespa/start-telegraf.sh");
    private static final String STOP_TELEGRAF_SCRIPT = Defaults.getDefaults().underVespaHome("libexec/vespa/stop-telegraf.sh");
    private static final String TELEGRAF_CONFIG_TEMPLATE_PATH = "templates/telegraf.conf.vm";
    private final TelegrafRegistry telegrafRegistry;
    private static final Logger logger = Logger.getLogger(Telegraf.class.getName());

    @Inject
    public Telegraf(TelegrafRegistry telegrafRegistry, TelegrafConfig telegrafConfig) {
        this.telegrafRegistry = telegrafRegistry;
        telegrafRegistry.addInstance(this);
        Telegraf.writeConfig(telegrafConfig, (Writer)Exceptions.uncheck(() -> new FileWriter(TELEGRAF_CONFIG_PATH)), TELEGRAF_LOG_FILE_PATH);
        this.restartTelegraf();
    }

    protected static void writeConfig(TelegrafConfig telegrafConfig, Writer writer, String logFilePath) {
        VelocityContext context = new VelocityContext();
        context.put("logFilePath", (Object)logFilePath);
        context.put("intervalSeconds", (Object)telegrafConfig.intervalSeconds());
        context.put("cloudwatchPlugins", telegrafConfig.cloudWatch());
        context.put("protocol", (Object)(telegrafConfig.isHostedVespa() ? "https" : "http"));
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.init();
        velocityEngine.evaluate((Context)context, writer, "TelegrafConfigWriter", Telegraf.getTemplateReader());
        Exceptions.uncheck(writer::close);
    }

    private void restartTelegraf() {
        this.executeCommand(STOP_TELEGRAF_SCRIPT);
        this.executeCommand(START_TELEGRAF_SCRIPT);
    }

    private void stopTelegraf() {
        this.executeCommand(STOP_TELEGRAF_SCRIPT);
    }

    private void executeCommand(String command) {
        logger.info(String.format("Running command: %s", command));
        ProcessExecutor processExecutor = new ProcessExecutor.Builder(10).successExitCodes(new int[]{0}).build();
        ProcessResult processResult = (ProcessResult)((Optional)Exceptions.uncheck(() -> processExecutor.execute(command))).orElseThrow(() -> new RuntimeException("Timed out running command: " + command));
        logger.log(Level.FINE, () -> String.format("Exit code: %d\nstdOut: %s\nstdErr: %s", processResult.exitCode, processResult.stdOut, processResult.stdErr));
        if (!processResult.stdErr.isBlank()) {
            logger.warning(String.format("stdErr not empty: %s", processResult.stdErr));
        }
    }

    private static Reader getTemplateReader() {
        return new InputStreamReader(Telegraf.class.getClassLoader().getResourceAsStream(TELEGRAF_CONFIG_TEMPLATE_PATH));
    }

    public void deconstruct() {
        this.telegrafRegistry.removeInstance(this);
        if (this.telegrafRegistry.isEmpty()) {
            this.stopTelegraf();
        }
    }
}

