/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.ConfigURI;
import com.yahoo.messagebus.ConfigHandler;
import com.yahoo.messagebus.MessagebusConfig;
import com.yahoo.messagebus.routing.HopSpec;
import com.yahoo.messagebus.routing.RouteSpec;
import com.yahoo.messagebus.routing.RoutingSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;

public final class ConfigAgent
implements ConfigSubscriber.SingleSubscriber<MessagebusConfig> {
    private final ConfigURI configURI;
    private final ConfigHandler handler;
    private ConfigSubscriber subscriber;

    public ConfigAgent(String configId, ConfigHandler handler) {
        this.configURI = ConfigURI.createFromId((String)configId);
        this.handler = handler;
    }

    public ConfigAgent(ConfigURI configURI, ConfigHandler handler) {
        this.configURI = configURI;
        this.handler = handler;
    }

    public ConfigAgent(MessagebusConfig config, ConfigHandler handler) {
        this.configURI = null;
        this.handler = handler;
        this.configure(config);
    }

    public void reload(long generation) {
        if (this.subscriber != null) {
            this.subscriber.reload(generation);
        }
    }

    public void subscribe() {
        if (this.configURI != null) {
            this.subscriber = new ConfigSubscriber(this.configURI.getSource());
            this.subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, MessagebusConfig.class, this.configURI.getConfigId());
        }
    }

    public void configure(MessagebusConfig config) {
        RoutingSpec routing = new RoutingSpec();
        for (int table = 0; table < config.routingtable().size(); ++table) {
            MessagebusConfig.Routingtable tableConfig = config.routingtable(table);
            RoutingTableSpec tableSpec = new RoutingTableSpec(tableConfig.protocol());
            for (int hop = 0; hop < tableConfig.hop().size(); ++hop) {
                MessagebusConfig.Routingtable.Hop hopConfig = tableConfig.hop(hop);
                HopSpec hopSpec = new HopSpec(hopConfig.name(), hopConfig.selector());
                for (int recipient = 0; recipient < hopConfig.recipient().size(); ++recipient) {
                    hopSpec.addRecipient(hopConfig.recipient(recipient));
                }
                hopSpec.setIgnoreResult(hopConfig.ignoreresult());
                tableSpec.addHop(hopSpec);
            }
            for (int route = 0; route < tableConfig.route().size(); ++route) {
                MessagebusConfig.Routingtable.Route routeConfig = tableConfig.route(route);
                RouteSpec routeSpec = new RouteSpec(routeConfig.name());
                for (int hop = 0; hop < routeConfig.hop().size(); ++hop) {
                    routeSpec.addHop(routeConfig.hop(hop));
                }
                tableSpec.addRoute(routeSpec);
            }
            routing.addTable(tableSpec);
        }
        this.handler.setupRouting(routing);
    }

    public void shutdown() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

