/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.routing.Resender;
import com.yahoo.messagebus.routing.RoutingNode;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SendProxy
implements MessageHandler,
ReplyHandler {
    private static final Logger log = Logger.getLogger(SendProxy.class.getName());
    private final MessageBus mbus;
    private final Network net;
    private final Resender resender;
    private Message msg = null;
    private boolean logTrace = false;

    public SendProxy(MessageBus mbus, Network net, Resender resender) {
        this.mbus = mbus;
        this.net = net;
        this.resender = resender;
    }

    @Override
    public void handleMessage(Message msg) {
        Trace trace = msg.getTrace();
        if (trace.getLevel() == 0) {
            if (log.isLoggable(Level.FINEST)) {
                trace.setLevel(9);
                this.logTrace = true;
            } else if (log.isLoggable(Level.FINE)) {
                trace.setLevel(6);
                this.logTrace = true;
            }
        }
        this.msg = msg;
        RoutingNode root = new RoutingNode(this.mbus, this.net, this.resender, this, msg);
        root.send();
    }

    @Override
    public void handleReply(Reply reply) {
        if (reply == null) {
            this.msg.discard();
        } else {
            Trace trace = this.msg.getTrace();
            if (this.logTrace) {
                if (reply.hasErrors()) {
                    log.log(Level.FINE, () -> "Trace for reply with error(s):\n" + String.valueOf(reply.getTrace()));
                } else {
                    log.log(Level.FINEST, () -> "Trace for reply:\n" + String.valueOf(reply.getTrace()));
                }
                Trace empty = new Trace();
                trace.swap(empty);
            } else if (trace.getLevel() > 0) {
                trace.getRoot().addChild(reply.getTrace().getRoot());
                trace.getRoot().normalize();
            }
            reply.swapState(this.msg);
            reply.setMessage(this.msg);
            ReplyHandler handler = reply.popHandler();
            handler.handleReply(reply);
        }
    }
}

