/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopBlueprint;
import com.yahoo.messagebus.routing.HopSpec;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RouteSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class RoutingTable {
    private final Map<String, HopBlueprint> hops = new LinkedHashMap<String, HopBlueprint>();
    private final Map<String, Route> routes = new LinkedHashMap<String, Route>();

    public RoutingTable(RoutingTableSpec spec) {
        int i;
        for (i = 0; i < spec.getNumHops(); ++i) {
            HopSpec hopSpec = spec.getHop(i);
            this.hops.put(hopSpec.getName(), new HopBlueprint(hopSpec));
        }
        for (i = 0; i < spec.getNumRoutes(); ++i) {
            RouteSpec routeSpec = spec.getRoute(i);
            Route route = new Route();
            for (int j = 0; j < routeSpec.getNumHops(); ++j) {
                route.addHop(Hop.parse(routeSpec.getHop(j)));
            }
            this.routes.put(routeSpec.getName(), route);
        }
    }

    public boolean hasHops() {
        return !this.hops.isEmpty();
    }

    public int getNumHops() {
        return this.hops.size();
    }

    public HopIterator getHopIterator() {
        return new HopIterator(this.hops);
    }

    public RouteIterator getRouteIterator() {
        return new RouteIterator(this.routes);
    }

    public boolean hasRoutes() {
        return !this.routes.isEmpty();
    }

    public int getNumRoutes() {
        return this.routes.size();
    }

    public boolean hasHop(String name) {
        return this.hops.containsKey(name);
    }

    public HopBlueprint getHop(String name) {
        return this.hops.get(name);
    }

    public boolean hasRoute(String name) {
        return this.routes.containsKey(name);
    }

    public Route getRoute(String name) {
        return this.routes.get(name);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("RoutingTable(hops = { ");
        int i = 0;
        for (String name : this.hops.keySet()) {
            ret.append("'").append(name).append("' : ").append(this.hops.get(name));
            if (i++ >= this.hops.size() - 1) continue;
            ret.append(", ");
        }
        ret.append(" }, routes = { ");
        i = 0;
        for (String name : this.routes.keySet()) {
            ret.append("'").append(name).append("' : ").append(this.routes.get(name));
            if (i++ >= this.routes.size()) continue;
            ret.append(", ");
        }
        ret.append(" })");
        return ret.toString();
    }

    public static class HopIterator {
        private Iterator<Map.Entry<String, HopBlueprint>> it;
        private Map.Entry<String, HopBlueprint> entry;

        private HopIterator(Map<String, HopBlueprint> hops) {
            this.it = hops.entrySet().iterator();
            this.next();
        }

        public void next() {
            this.entry = this.it.hasNext() ? this.it.next() : null;
        }

        public boolean isValid() {
            return this.entry != null;
        }

        public String getName() {
            return this.entry.getKey();
        }

        public HopBlueprint getHop() {
            return this.entry.getValue();
        }
    }

    public static class RouteIterator {
        private Iterator<Map.Entry<String, Route>> it;
        private Map.Entry<String, Route> entry;

        private RouteIterator(Map<String, Route> routes) {
            this.it = routes.entrySet().iterator();
            this.next();
        }

        public void next() {
            this.entry = this.it.hasNext() ? this.it.next() : null;
        }

        public boolean isValid() {
            return this.entry != null;
        }

        public String getName() {
            return this.entry.getKey();
        }

        public Route getRoute() {
            return this.entry.getValue();
        }
    }
}

