/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCService;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public class RPCServicePool {
    private final RPCNetwork net;
    private final Map<Long, ServiceLRUCache> mapOfServiceCache;
    private final int maxSize;

    public RPCServicePool(RPCNetwork net, int maxSize) {
        this.net = net;
        this.mapOfServiceCache = new CopyOnWriteHashMap();
        this.maxSize = maxSize;
    }

    public RPCServiceAddress resolve(String pattern) {
        return this.getPerThreadCache().computeIfAbsent(pattern, key -> RPCService.create(this.net.getMirror(), key)).resolve();
    }

    private ServiceLRUCache getPerThreadCache() {
        return this.mapOfServiceCache.computeIfAbsent(Thread.currentThread().getId(), key -> new ServiceLRUCache(this.maxSize));
    }

    public int getSize() {
        return this.getPerThreadCache().size();
    }

    public boolean hasService(String pattern) {
        return this.getPerThreadCache().containsKey(pattern);
    }

    private static class ServiceLRUCache
    extends LinkedHashMap<String, RPCService> {
        private final int maxSize;

        ServiceLRUCache(int maxSize) {
            super(16, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RPCService> entry) {
            return this.size() > this.maxSize;
        }
    }
}

