/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.Connectable;
import com.yahoo.messagebus.DestinationSessionParams;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DestinationSession
implements Connectable,
MessageHandler {
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final String name;
    private final boolean broadcastName;
    private final MessageBus mbus;
    private final MessageHandler msgHandler;

    DestinationSession(MessageBus mbus, DestinationSessionParams params) {
        this.mbus = mbus;
        this.name = params.getName();
        this.broadcastName = params.getBroadcastName();
        this.msgHandler = params.getMessageHandler();
    }

    public boolean destroy() {
        if (!this.destroyed.getAndSet(true)) {
            this.close();
            return true;
        }
        return false;
    }

    public void close() {
        this.mbus.unregisterSession(this.name, this.broadcastName);
        this.mbus.sync();
    }

    public void acknowledge(Message msg) {
        EmptyReply ack = new EmptyReply();
        msg.swapState(ack);
        this.reply(ack);
    }

    public void reply(Reply reply) {
        ReplyHandler handler = reply.popHandler();
        handler.handleReply(reply);
    }

    public MessageHandler getMessageHandler() {
        return this.msgHandler;
    }

    public String getConnectionSpec() {
        return this.mbus.getConnectionSpec() + "/" + this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void handleMessage(Message msg) {
        this.msgHandler.handleMessage(msg);
    }

    @Override
    public void connect() {
        this.mbus.connect(this.name, this.broadcastName);
    }
}

