/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCService;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public class RPCServicePool {
    private final RPCNetwork net;
    private final ThreadLocalCache services = new ThreadLocalCache();
    private final int maxSize;

    public RPCServicePool(RPCNetwork net, int maxSize) {
        this.net = net;
        this.maxSize = maxSize;
    }

    public RPCServiceAddress resolve(String pattern) {
        RPCService service = (RPCService)((ServiceLRUCache)this.services.get()).get(pattern);
        if (service == null) {
            service = new RPCService(this.net.getMirror(), pattern);
            ((ServiceLRUCache)this.services.get()).put(pattern, service);
        }
        return service.resolve();
    }

    public int getSize() {
        return ((ServiceLRUCache)this.services.get()).size();
    }

    public boolean hasService(String pattern) {
        return ((ServiceLRUCache)this.services.get()).containsKey(pattern);
    }

    private class ServiceLRUCache
    extends LinkedHashMap<String, RPCService> {
        ServiceLRUCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RPCService> entry) {
            return this.size() > RPCServicePool.this.maxSize;
        }
    }

    private class ThreadLocalCache
    extends ThreadLocal<ServiceLRUCache> {
        private ThreadLocalCache() {
        }

        @Override
        protected ServiceLRUCache initialValue() {
            return new ServiceLRUCache();
        }
    }
}

