/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.component.Version;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.log.LogLevel;
import com.yahoo.text.Utf8Array;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RPCTarget
implements RequestWaiter {
    private static final Logger log = Logger.getLogger(RPCTarget.class.getName());
    private final AtomicInteger ref = new AtomicInteger(1);
    private final String name;
    private final Target target;
    private boolean targetInvoked = false;
    private Version version = null;
    private List<VersionHandler> versionHandlers = new LinkedList<VersionHandler>();

    public RPCTarget(Spec spec, Supervisor orb) {
        this.name = spec.toString();
        this.target = orb.connect(spec);
    }

    Target getJRTTarget() {
        return this.target;
    }

    void addRef() {
        this.ref.incrementAndGet();
    }

    void subRef() {
        if (this.ref.decrementAndGet() == 0) {
            this.target.close();
        }
    }

    int getRefCount() {
        return this.ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveVersion(double timeout, VersionHandler handler) {
        boolean hasVersion = false;
        boolean shouldInvoke = false;
        boolean shouldLog = log.isLoggable((Level)LogLevel.DEBUG);
        RPCTarget rPCTarget = this;
        synchronized (rPCTarget) {
            if (this.version != null) {
                if (shouldLog) {
                    log.log((Level)LogLevel.DEBUG, "Version already available for target '" + this.name + "' (version " + this.version + ").");
                }
                hasVersion = true;
            } else {
                if (shouldLog) {
                    log.log((Level)LogLevel.DEBUG, "Registering version handler '" + handler + "' for target '" + this.name + "'.");
                }
                this.versionHandlers.add(handler);
                if (!this.targetInvoked) {
                    this.targetInvoked = true;
                    shouldInvoke = true;
                }
            }
        }
        if (hasVersion) {
            handler.handleVersion(this.version);
        } else if (shouldInvoke) {
            if (shouldLog) {
                log.log((Level)LogLevel.DEBUG, "Invoking mbus.getVersion() on target '" + this.name + "'");
            }
            Request req = new Request("mbus.getVersion");
            this.target.invokeAsync(req, timeout, (RequestWaiter)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestDone(Request req) {
        List<VersionHandler> handlers;
        boolean shouldLog = log.isLoggable((Level)LogLevel.DEBUG);
        RPCTarget rPCTarget = this;
        synchronized (rPCTarget) {
            this.targetInvoked = false;
            if (req.checkReturnTypes("s")) {
                Utf8Array str = req.returnValues().get(0).asUtf8Array();
                try {
                    this.version = new Version(str);
                    if (shouldLog) {
                        log.log((Level)LogLevel.DEBUG, "Target '" + this.name + "' has version " + this.version + ".");
                    }
                }
                catch (IllegalArgumentException e) {
                    log.log(LogLevel.WARNING, "Failed to parse '" + str + "' as version for target '" + this.name + "'.", e);
                }
            } else {
                log.log(LogLevel.INFO, "Method mbus.getVersion() failed for target '" + this.name + "'; " + req.errorMessage());
            }
            handlers = this.versionHandlers;
            this.versionHandlers = new LinkedList<VersionHandler>();
        }
        for (VersionHandler handler : handlers) {
            handler.handleVersion(this.version);
        }
    }

    public static interface VersionHandler {
        public void handleVersion(Version var1);
    }
}

