/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.routing.RoutingPolicy;
import com.yahoo.text.Utf8String;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtocolRepository {
    private static final Logger log = Logger.getLogger(ProtocolRepository.class.getName());
    private final CopyOnWriteHashMap<String, Protocol> protocols = new CopyOnWriteHashMap();
    private final CopyOnWriteHashMap<String, RoutingPolicy> routingPolicyCache = new CopyOnWriteHashMap();

    public void putProtocol(Protocol protocol) {
        if (this.protocols.put((Object)protocol.getName(), (Object)protocol) != null) {
            this.clearPolicyCache();
        }
    }

    public boolean hasProtocol(String name) {
        return this.protocols.containsKey((Object)name);
    }

    public Protocol getProtocol(String name) {
        return (Protocol)this.protocols.get((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingPolicy getRoutingPolicy(String protocolName, String policyName, String policyParam) {
        String cacheKey = protocolName + "." + policyName + "." + policyParam;
        RoutingPolicy ret = (RoutingPolicy)this.routingPolicyCache.get((Object)cacheKey);
        if (ret != null) {
            return ret;
        }
        ProtocolRepository protocolRepository = this;
        synchronized (protocolRepository) {
            ret = (RoutingPolicy)this.routingPolicyCache.get((Object)cacheKey);
            if (ret != null) {
                return ret;
            }
            Protocol protocol = this.getProtocol(protocolName);
            if (protocol == null) {
                log.log((Level)LogLevel.ERROR, "Protocol '" + protocolName + "' not supported.");
                return null;
            }
            try {
                ret = protocol.createPolicy(policyName, policyParam);
            }
            catch (RuntimeException e) {
                log.log((Level)LogLevel.ERROR, "Protcol '" + protocolName + "' threw an exception: " + e.getMessage(), e);
                if (ret != null) {
                    ret.destroy();
                }
                return null;
            }
            if (ret == null) {
                log.log((Level)LogLevel.ERROR, "Protocol '" + protocolName + "' failed to create routing policy '" + policyName + "' with parameter '" + policyParam + "'.");
                return null;
            }
            this.routingPolicyCache.put((Object)cacheKey, (Object)ret);
        }
        return ret;
    }

    public final RoutingPolicy getRoutingPolicy(Utf8String protocolName, String policyName, String policyParam) {
        return this.getRoutingPolicy(protocolName.toString(), policyName, policyParam);
    }

    public synchronized void clearPolicyCache() {
        for (RoutingPolicy policy : this.routingPolicyCache.values()) {
            policy.destroy();
        }
        this.routingPolicyCache.clear();
    }
}

