/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing.test;

import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingPolicy;
import com.yahoo.messagebus.routing.test.CustomPolicy;
import com.yahoo.messagebus.test.SimpleProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomPolicyFactory
implements SimpleProtocol.PolicyFactory {
    private boolean selectOnRetry;
    private final List<Integer> consumableErrors = new ArrayList<Integer>();

    public CustomPolicyFactory() {
        this(true);
    }

    public CustomPolicyFactory(boolean selectOnRetry) {
        this(selectOnRetry, new ArrayList<Integer>());
    }

    public CustomPolicyFactory(boolean selectOnRetry, int consumableError) {
        this(selectOnRetry, Arrays.asList(consumableError));
    }

    public CustomPolicyFactory(boolean selectOnRetry, List<Integer> consumableErrors) {
        this.selectOnRetry = selectOnRetry;
        this.consumableErrors.addAll(consumableErrors);
    }

    @Override
    public RoutingPolicy create(String param) {
        return new CustomPolicy(this.selectOnRetry, this.consumableErrors, CustomPolicyFactory.parseRoutes(param));
    }

    public static List<Route> parseRoutes(String routes) {
        ArrayList<Route> ret = new ArrayList<Route>();
        if (routes != null && !routes.isEmpty()) {
            for (String route : routes.split(",")) {
                Route r = Route.parse(route);
                assert (route.equals(r.toString()));
                ret.add(r);
            }
        }
        return ret;
    }
}

