/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.ApplicationSpec;
import com.yahoo.messagebus.routing.ErrorDirective;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.PolicyDirective;
import com.yahoo.messagebus.routing.RouteDirective;
import com.yahoo.messagebus.routing.RoutingSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import com.yahoo.messagebus.routing.TcpDirective;
import com.yahoo.messagebus.routing.VerbatimDirective;
import java.util.ArrayList;
import java.util.List;

public class HopSpec {
    private final String name;
    private final String selector;
    private final List<String> recipients = new ArrayList<String>();
    private final boolean verify;
    private boolean ignoreResult = false;

    public HopSpec(String name, String selector) {
        this(name, selector, true);
    }

    public HopSpec(String name, String selector, boolean verify) {
        this.name = name;
        this.selector = selector;
        this.verify = verify;
    }

    public HopSpec(HopSpec obj) {
        this.name = obj.name;
        this.selector = obj.selector;
        this.verify = obj.verify;
        for (String recipient : obj.recipients) {
            this.recipients.add(recipient);
        }
        this.ignoreResult = obj.ignoreResult;
    }

    public String getName() {
        return this.name;
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean hasRecipients() {
        return !this.recipients.isEmpty();
    }

    public int getNumRecipients() {
        return this.recipients.size();
    }

    public String getRecipient(int i) {
        return this.recipients.get(i);
    }

    public HopSpec addRecipient(String recipient) {
        this.recipients.add(recipient);
        return this;
    }

    public HopSpec addRecipients(List<String> recipients) {
        this.recipients.addAll(recipients);
        return this;
    }

    public HopSpec setRecipient(int i, String recipient) {
        this.recipients.set(i, recipient);
        return this;
    }

    public String removeRecipient(int i) {
        return this.recipients.remove(i);
    }

    public HopSpec clearRecipients() {
        this.recipients.clear();
        return this;
    }

    public boolean getIgnoreResult() {
        return this.ignoreResult;
    }

    public HopSpec setIgnoreResult(boolean ignoreResult) {
        this.ignoreResult = ignoreResult;
        return this;
    }

    public boolean verify(ApplicationSpec app, RoutingTableSpec table, List<String> errors) {
        if (this.verify) {
            HopSpec.verify(app, table, null, this.recipients, this.selector, errors, "hop '" + this.name + "' in routing table '" + table.getProtocol() + "'");
        }
        return errors.isEmpty();
    }

    static boolean verify(ApplicationSpec app, RoutingTableSpec table, Hop parent, List<String> children, String selector, List<String> errors, String context) {
        String serviceName;
        Hop hop = Hop.parse(selector);
        int len = hop.getNumDirectives();
        for (int i = 0; i < len; ++i) {
            HopDirective dir = hop.getDirective(i);
            if (!(dir instanceof ErrorDirective)) continue;
            errors.add("For " + context + "; " + ((ErrorDirective)dir).getMessage());
            return false;
        }
        if (parent != null && parent.getNumDirectives() != 1 && !parent.matches(hop)) {
            errors.add("Selector '" + parent.getServiceName() + "' does not match " + context + ".");
            return false;
        }
        boolean verifyServiceName = true;
        boolean allowRecipients = false;
        int len2 = hop.getNumDirectives();
        for (int i = 0; i < len2; ++i) {
            HopDirective dir = hop.getDirective(i);
            if (dir instanceof ErrorDirective) continue;
            if (dir instanceof PolicyDirective) {
                allowRecipients = true;
                verifyServiceName = false;
                continue;
            }
            if (dir instanceof RouteDirective) {
                String routeName = ((RouteDirective)dir).getName();
                if (!table.hasRoute(routeName)) {
                    errors.add(HopSpec.capitalize(context) + " references route '" + routeName + "' which does not exist.");
                    return false;
                }
                verifyServiceName = false;
                continue;
            }
            if (dir instanceof TcpDirective) {
                verifyServiceName = false;
                continue;
            }
            if (!(dir instanceof VerbatimDirective)) continue;
        }
        if (verifyServiceName && !table.hasRoute(serviceName = hop.getServiceName()) && !table.hasHop(serviceName) && !app.isService(table.getProtocol(), serviceName)) {
            errors.add(HopSpec.capitalize(context) + " references '" + serviceName + "' which is neither a service, a route nor another hop.");
            return false;
        }
        if (children != null && children.size() > 0) {
            if (!allowRecipients) {
                errors.add(HopSpec.capitalize(context) + " has recipients but no policy directive.");
                return false;
            }
            for (String child : children) {
                HopSpec.verify(app, table, hop, null, child, errors, "recipient '" + child + "' in " + context);
            }
        }
        return true;
    }

    public void toConfig(StringBuilder cfg, String prefix) {
        int numRecipients;
        cfg.append(prefix).append("name ").append(RoutingSpec.toConfigString(this.name)).append("\n");
        cfg.append(prefix).append("selector ").append(RoutingSpec.toConfigString(this.selector)).append("\n");
        if (this.ignoreResult) {
            cfg.append(prefix).append("ignoreresult true\n");
        }
        if ((numRecipients = this.recipients.size()) > 0) {
            cfg.append(prefix).append("recipient[").append(numRecipients).append("]\n");
            for (int i = 0; i < numRecipients; ++i) {
                cfg.append(prefix).append("recipient[").append(i).append("] ");
                cfg.append(RoutingSpec.toConfigString(this.recipients.get(i))).append("\n");
            }
        }
    }

    private static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        this.toConfig(ret, "");
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HopSpec)) {
            return false;
        }
        HopSpec rhs = (HopSpec)obj;
        if (!this.name.equals(rhs.name)) {
            return false;
        }
        if (!this.selector.equals(rhs.selector)) {
            return false;
        }
        return this.recipients.equals(rhs.recipients);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.selector != null ? this.selector.hashCode() : 0);
        result = 31 * result + (this.recipients != null ? this.recipients.hashCode() : 0);
        result = 31 * result + (this.verify ? 1 : 0);
        result = 31 * result + (this.ignoreResult ? 1 : 0);
        return result;
    }
}

