/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.ApplicationSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoutingSpec {
    private final List<RoutingTableSpec> tables = new ArrayList<RoutingTableSpec>();
    private final boolean verify;

    public RoutingSpec() {
        this(true);
    }

    public RoutingSpec(boolean verify) {
        this.verify = verify;
    }

    public RoutingSpec(RoutingSpec spec) {
        this.verify = spec.verify;
        for (RoutingTableSpec table : spec.tables) {
            this.tables.add(new RoutingTableSpec(table));
        }
    }

    public boolean hasTables() {
        return !this.tables.isEmpty();
    }

    public int getNumTables() {
        return this.tables.size();
    }

    public RoutingTableSpec getTable(int i) {
        return this.tables.get(i);
    }

    public RoutingSpec setTable(int i, RoutingTableSpec table) {
        this.tables.set(i, table);
        return this;
    }

    public RoutingSpec addTable(RoutingTableSpec table) {
        this.tables.add(table);
        return this;
    }

    public RoutingTableSpec removeTable(int i) {
        return this.tables.remove(i);
    }

    public RoutingSpec clearTables() {
        this.tables.clear();
        return this;
    }

    public boolean verify(ApplicationSpec app, List<String> errors) {
        if (this.verify) {
            HashMap<String, Integer> tableNames = new HashMap<String, Integer>();
            for (RoutingTableSpec routingTableSpec : this.tables) {
                String name = routingTableSpec.getProtocol();
                int count = tableNames.containsKey(name) ? (Integer)tableNames.get(name) : 0;
                tableNames.put(name, count + 1);
                routingTableSpec.verify(app, errors);
            }
            for (Map.Entry entry : tableNames.entrySet()) {
                int count = (Integer)entry.getValue();
                if (count <= 1) continue;
                errors.add("Routing table '" + (String)entry.getKey() + "' is defined " + count + " times.");
            }
        }
        return errors.isEmpty();
    }

    public void toConfig(StringBuilder cfg, String prefix) {
        int numTables = this.tables.size();
        if (numTables > 0) {
            cfg.append(prefix).append("routingtable[").append(numTables).append("]\n");
            for (int i = 0; i < numTables; ++i) {
                this.tables.get(i).toConfig(cfg, prefix + "routingtable[" + i + "].");
            }
        }
    }

    static String toConfigString(String input) {
        if (input == null) {
            return "null";
        }
        StringBuilder ret = new StringBuilder(2 + input.length());
        ret.append("\"");
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            if (input.charAt(i) == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (input.charAt(i) == '\"') {
                ret.append("\\\"");
                continue;
            }
            if (input.charAt(i) == '\n') {
                ret.append("\\n");
                continue;
            }
            if (input.charAt(i) == '\u0000') {
                ret.append("\\x00");
                continue;
            }
            ret.append(input.charAt(i));
        }
        ret.append("\"");
        return ret.toString();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        this.toConfig(ret, "");
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RoutingSpec)) {
            return false;
        }
        RoutingSpec rhs = (RoutingSpec)obj;
        return this.tables.equals(rhs.tables);
    }

    public int hashCode() {
        int result = this.tables != null ? this.tables.hashCode() : 0;
        result = 31 * result + (this.verify ? 1 : 0);
        return result;
    }
}

