/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.metrics.RouteMetricSet;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.routing.Resender;
import com.yahoo.messagebus.routing.RoutingNode;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SendProxy
implements MessageHandler,
ReplyHandler {
    private static final Logger log = Logger.getLogger(SendProxy.class.getName());
    private final MessageBus mbus;
    private final Network net;
    private final Resender resender;
    private Message msg = null;
    private boolean logTrace = false;
    private long sendTime = 0L;

    public SendProxy(MessageBus mbus, Network net, Resender resender) {
        this.mbus = mbus;
        this.net = net;
        this.resender = resender;
        this.sendTime = SystemTimer.INSTANCE.milliTime();
    }

    @Override
    public void handleMessage(Message msg) {
        Trace trace = msg.getTrace();
        if (trace.getLevel() == 0) {
            if (log.isLoggable((Level)LogLevel.SPAM)) {
                trace.setLevel(9);
                this.logTrace = true;
            } else if (log.isLoggable((Level)LogLevel.DEBUG)) {
                trace.setLevel(6);
                this.logTrace = true;
            }
        }
        this.msg = msg;
        RoutingNode root = new RoutingNode(this.mbus, this.net, this.resender, this, msg);
        root.send();
    }

    @Override
    public void handleReply(Reply reply) {
        if (reply == null) {
            this.msg.discard();
        } else {
            Trace trace = this.msg.getTrace();
            if (this.logTrace) {
                if (reply.hasErrors()) {
                    log.log((Level)LogLevel.DEBUG, "Trace for reply with error(s):\n" + reply.getTrace());
                } else if (log.isLoggable((Level)LogLevel.SPAM)) {
                    log.log((Level)LogLevel.SPAM, "Trace for reply:\n" + reply.getTrace());
                }
                Trace empty = new Trace();
                trace.swap(empty);
            } else if (trace.getLevel() > 0) {
                trace.getRoot().addChild(reply.getTrace().getRoot());
                trace.getRoot().normalize();
            }
            reply.swapState(this.msg);
            reply.setMessage(this.msg);
            if (this.msg.getRoute() != null) {
                RouteMetricSet metrics = this.mbus.getMetrics().getRouteMetrics(this.msg.getRoute());
                for (int i = 0; i < reply.getNumErrors(); ++i) {
                    metrics.addFailure(reply.getError(i));
                }
                if (reply.getNumErrors() == 0) {
                    metrics.latency.addValue(this.msg.getTimeReceived() - this.sendTime);
                }
            }
            ReplyHandler handler = reply.popHandler();
            handler.handleReply(reply);
        }
    }
}

