/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.mcp;

import ai.vespa.mcp.JdiscMcpServer;
import ai.vespa.mcp.McpHttpTransport;
import ai.vespa.mcp.McpTools;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.searchchain.ExecutionFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class McpJdiscHandler
extends ThreadedHttpRequestHandler {
    private static final Logger logger = Logger.getLogger(McpJdiscHandler.class.getName());
    private final McpHttpTransport transport;
    private final JdiscMcpServer mcpServer;

    @Inject
    public McpJdiscHandler(Executor executor, Metric metrics, ExecutionFactory executionFactory, CompiledQueryProfileRegistry queryProfileRegistry) {
        super(executor, metrics, true);
        McpTools tools = new McpTools(executionFactory, queryProfileRegistry);
        this.mcpServer = new JdiscMcpServer(tools);
        this.transport = this.mcpServer.getTransport();
    }

    public HttpResponse handle(HttpRequest request) {
        return this.handle(request, null);
    }

    public HttpResponse handle(HttpRequest request, ContentChannel channel) {
        String method = request.getMethod().toString();
        String path = request.getUri().getPath();
        byte[] body = new byte[]{};
        try {
            if (request.getData() != null) {
                body = request.getData().readAllBytes();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to read request body", e);
            return this.transport.createErrorResponse(400, "Failed to read request body", null);
        }
        logger.info("=== RECEIVED REQUEST: " + method + " " + path + " ===");
        logger.info("=== BODY: " + new String(body, StandardCharsets.UTF_8) + " ===");
        if (!path.startsWith("/mcp/")) {
            return this.transport.createErrorResponse(404, "Not Found", null);
        }
        return switch (method) {
            case "GET" -> this.transport.handleGet(request);
            case "POST" -> this.transport.handlePost(request, body);
            case "DELETE" -> this.transport.handleDelete(request);
            default -> this.transport.createErrorResponse(405, "Only GET, POST, and DELETE requests are allowed", null);
        };
    }

    public void destroy() {
        try {
            if (this.mcpServer != null) {
                this.mcpServer.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error closing MCP server during handler destruction", e);
        }
        super.destroy();
    }
}

