/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.logserver.protocol;

import ai.vespa.logserver.protocol.protobuf.LogProtocol;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import java.time.Instant;
import java.util.List;
import java.util.logging.Level;

class ProtobufSerialization {
    private ProtobufSerialization() {
    }

    static List<LogMessage> fromLogRequest(byte[] logRequestPayload) {
        try {
            LogProtocol.LogRequest logRequest = LogProtocol.LogRequest.parseFrom(logRequestPayload);
            return logRequest.getLogMessagesList().stream().map(ProtobufSerialization::fromLogRequest).toList();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse log request: " + e.getMessage(), e);
        }
    }

    static byte[] toLogRequest(List<LogMessage> logMessages) {
        LogProtocol.LogRequest.Builder builder = LogProtocol.LogRequest.newBuilder();
        for (LogMessage logMessage : logMessages) {
            builder.addLogMessages(ProtobufSerialization.toLogRequestMessage(logMessage));
        }
        return builder.build().toByteArray();
    }

    static byte[] toLogResponse() {
        return LogProtocol.LogResponse.newBuilder().build().toByteArray();
    }

    static void fromLogResponse(byte[] logResponsePayload) {
        try {
            LogProtocol.LogResponse.parseFrom(logResponsePayload);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse log response: " + e.getMessage(), e);
        }
    }

    private static LogMessage fromLogRequest(LogProtocol.LogMessage message) {
        return LogMessage.of((Instant)Instant.ofEpochSecond(0L, message.getTimeNanos()), (String)message.getHostname(), (long)message.getProcessId(), (long)message.getThreadId(), (String)message.getService(), (String)message.getComponent(), (Level)ProtobufSerialization.fromLogMessageLevel(message.getLevel()), (String)message.getPayload());
    }

    private static LogProtocol.LogMessage toLogRequestMessage(LogMessage logMessage) {
        Instant timestamp = logMessage.getTimestamp();
        long timestampNanos = timestamp.getEpochSecond() * 1000000000L + (long)timestamp.getNano();
        return LogProtocol.LogMessage.newBuilder().setTimeNanos(timestampNanos).setHostname(logMessage.getHost()).setProcessId((int)logMessage.getProcessId()).setThreadId((int)logMessage.getThreadId().orElse(0L)).setService(logMessage.getService()).setComponent(logMessage.getComponent()).setLevel(ProtobufSerialization.toLogMessageLevel(logMessage.getLevel())).setPayload(logMessage.getPayload()).build();
    }

    private static Level fromLogMessageLevel(LogProtocol.LogMessage.Level level) {
        switch (level) {
            case FATAL: {
                return LogLevel.FATAL;
            }
            case ERROR: {
                return LogLevel.ERROR;
            }
            case WARNING: {
                return LogLevel.WARNING;
            }
            case CONFIG: {
                return LogLevel.CONFIG;
            }
            case INFO: {
                return LogLevel.INFO;
            }
            case EVENT: {
                return LogLevel.EVENT;
            }
            case DEBUG: {
                return LogLevel.DEBUG;
            }
            case SPAM: {
                return LogLevel.SPAM;
            }
        }
        return LogLevel.UNKNOWN;
    }

    private static LogProtocol.LogMessage.Level toLogMessageLevel(Level level) {
        Level vespaLevel = LogLevel.getVespaLogLevel((Level)level);
        if (vespaLevel.equals(LogLevel.FATAL)) {
            return LogProtocol.LogMessage.Level.FATAL;
        }
        if (vespaLevel.equals(LogLevel.ERROR)) {
            return LogProtocol.LogMessage.Level.ERROR;
        }
        if (vespaLevel.equals(LogLevel.WARNING)) {
            return LogProtocol.LogMessage.Level.WARNING;
        }
        if (vespaLevel.equals(LogLevel.CONFIG)) {
            return LogProtocol.LogMessage.Level.CONFIG;
        }
        if (vespaLevel.equals(LogLevel.INFO)) {
            return LogProtocol.LogMessage.Level.INFO;
        }
        if (vespaLevel.equals(LogLevel.EVENT)) {
            return LogProtocol.LogMessage.Level.EVENT;
        }
        if (vespaLevel.equals(LogLevel.DEBUG)) {
            return LogProtocol.LogMessage.Level.DEBUG;
        }
        if (vespaLevel.equals(LogLevel.SPAM)) {
            return LogProtocol.LogMessage.Level.SPAM;
        }
        return LogProtocol.LogMessage.Level.UNKNOWN;
    }
}

