/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.archive;

import com.yahoo.logserver.Server;
import com.yahoo.logserver.handlers.archive.ArchiverHandler;
import com.yahoo.plugin.Config;
import com.yahoo.plugin.Plugin;
import java.util.logging.Logger;

public class ArchiverPlugin
implements Plugin {
    private static final String DEFAULT_DIR = "logarchive";
    private static final String DEFAULT_MAXFILESIZE = "20971520";
    private static final String DEFAULT_COMPRESSION = "gzip";
    private final Server server = Server.getInstance();
    private static final Logger log = Logger.getLogger(ArchiverPlugin.class.getName());
    private ArchiverHandler archiver;

    @Override
    public String getPluginName() {
        return DEFAULT_DIR;
    }

    @Override
    public void initPlugin(Config config) {
        if (this.archiver != null) {
            log.finer("ArchivePlugin doubly initialized");
            throw new IllegalStateException("plugin already initialized: " + this.getPluginName());
        }
        String rootDir = config.get("dir", DEFAULT_DIR);
        int maxFileSize = config.getInt("maxfilesize", DEFAULT_MAXFILESIZE);
        String threadName = config.get("thread", this.getPluginName());
        String zip = config.get("compression", DEFAULT_COMPRESSION);
        this.archiver = new ArchiverHandler(rootDir, maxFileSize, zip);
        this.server.registerLogHandler(this.archiver, threadName);
        this.server.registerFlusher(this.archiver);
    }

    @Override
    public void shutdownPlugin() {
        if (this.archiver == null) {
            log.finer("ArchiverPlugin shutdown before initialize");
            throw new IllegalStateException("plugin not initialized: " + this.getPluginName());
        }
        this.server.unregisterLogHandler(this.archiver);
        this.server.unregisterFlusher(this.archiver);
        this.archiver.close();
        this.archiver = null;
    }
}

