/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver;

import com.yahoo.logserver.handlers.LogHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class Flusher
extends Thread {
    private static final Logger log = Logger.getLogger(Flusher.class.getName());
    private static final Flusher instance = new Flusher();
    private final List<WeakReference<LogHandler>> logHandlers = new ArrayList<WeakReference<LogHandler>>();

    Flusher() {
        super("flusher");
    }

    static void register(LogHandler logHandler) {
        instance.addHandler(logHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHandler(LogHandler logHandler) {
        List<WeakReference<LogHandler>> list = this.logHandlers;
        synchronized (list) {
            this.logHandlers.add(new WeakReference<LogHandler>(logHandler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            while (!this.isInterrupted()) {
                List<WeakReference<LogHandler>> list = this.logHandlers;
                synchronized (list) {
                    Iterator<WeakReference<LogHandler>> it = this.logHandlers.iterator();
                    while (it.hasNext()) {
                        WeakReference<LogHandler> r = it.next();
                        LogHandler h = (LogHandler)r.get();
                        if (h == null) {
                            it.remove();
                        } else {
                            h.flush();
                        }
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "Flushing " + h);
                    }
                }
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "flusher was interrupted", e);
        }
    }

    static {
        instance.start();
    }
}

