/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.archive;

import com.yahoo.log.LogMessage;
import com.yahoo.logserver.handlers.AbstractLogHandler;
import com.yahoo.logserver.handlers.archive.FilesArchived;
import com.yahoo.logserver.handlers.archive.LogWriter;
import com.yahoo.logserver.handlers.archive.LogWriterLRUCache;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiverHandler
extends AbstractLogHandler {
    private static final Logger log = Logger.getLogger(ArchiverHandler.class.getName());
    private File root;
    private String absoluteRootDir;
    private static final int maxFilesOpen = 100;
    private int maxFileSize;
    private final Calendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private final SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd/HH");
    private final LogWriterLRUCache logWriterLRUCache;
    private FilesArchived filesArchived;

    private ArchiverHandler() {
        this.dateformat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setLogFilter(null);
        this.logWriterLRUCache = new LogWriterLRUCache(100, 0.75f);
    }

    public ArchiverHandler(String rootDir, int maxFileSize) {
        this();
        this.setRootDir(rootDir);
        this.maxFileSize = maxFileSize;
    }

    private synchronized LogWriter getLogWriter(LogMessage m) throws IOException {
        Integer slot = this.dateHash(m.getTimestamp().toEpochMilli());
        LogWriter logWriter = (LogWriter)this.logWriterLRUCache.get(slot);
        if (logWriter != null) {
            return logWriter;
        }
        logWriter = new LogWriter(this.getPrefix(m), this.maxFileSize, this.filesArchived);
        this.logWriterLRUCache.put(slot, logWriter);
        return logWriter;
    }

    public int dateHash(long time) {
        this.calendar.setTimeInMillis(time);
        int year = this.calendar.get(1);
        int month = this.calendar.get(2) + 1;
        int day = this.calendar.get(5);
        int hour = this.calendar.get(11);
        return year * 1000000 + month * 10000 + day * 100 + hour;
    }

    public String getPrefix(LogMessage msg) {
        this.calendar.setTimeInMillis(msg.getTimestamp().toEpochMilli());
        StringBuilder result = new StringBuilder(this.absoluteRootDir.length() + 1 + 4 + 1 + 2 + 1 + 2 + 1 + 2);
        result.append(this.absoluteRootDir).append("/").append(this.dateformat.format(this.calendar.getTime()));
        return result.toString();
    }

    @Override
    public boolean doHandle(LogMessage msg) {
        try {
            LogWriter logWriter = this.getLogWriter(msg);
            logWriter.write(msg.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public synchronized void flush() {
        for (LogWriter l : this.logWriterLRUCache.values()) {
            try {
                l.flush();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Flushing failed", e);
            }
        }
    }

    @Override
    public synchronized void close() {
        Iterator it = this.logWriterLRUCache.values().iterator();
        while (it.hasNext()) {
            LogWriter l = (LogWriter)it.next();
            try {
                l.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Closing failed", e);
            }
            it.remove();
        }
    }

    private void setRootDir(String rootDir) {
        this.absoluteRootDir = new File(rootDir).getAbsolutePath();
        this.root = new File(this.absoluteRootDir);
        if (this.root.isDirectory()) {
            log.log(Level.FINE, () -> "Using " + this.absoluteRootDir + " as root");
        } else if (!this.root.mkdirs()) {
            log.log(Level.SEVERE, "Unable to create directory " + this.absoluteRootDir);
        } else {
            log.log(Level.FINE, () -> "Created root at " + this.absoluteRootDir);
        }
        this.filesArchived = new FilesArchived(this.root);
    }

    @Override
    public String toString() {
        return ArchiverHandler.class.getName() + ": root=" + this.absoluteRootDir;
    }
}

