/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.archive;

import com.yahoo.logserver.handlers.archive.LogWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogWriterLRUCache
extends LinkedHashMap<Integer, LogWriter> {
    private static final Logger log = Logger.getLogger(LogWriterLRUCache.class.getName());
    final int maxEntries = 100;

    public LogWriterLRUCache(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Integer, LogWriter> eldest) {
        if (this.size() > 100) {
            LogWriter logWriter = eldest.getValue();
            log.fine("Closing oldest LogWriter: " + logWriter);
            try {
                logWriter.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "closing LogWriter failed", e);
            }
            return true;
        }
        return false;
    }
}

