/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.replicator;

import com.yahoo.io.Connection;
import com.yahoo.io.ConnectionFactory;
import com.yahoo.io.Listener;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.handlers.AbstractLogHandler;
import com.yahoo.logserver.handlers.replicator.FormattedBufferCache;
import com.yahoo.logserver.handlers.replicator.ReplicatorConnection;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Replicator
extends AbstractLogHandler
implements ConnectionFactory {
    private static final Logger log = Logger.getLogger(Replicator.class.getName());
    private int port;
    private Listener listener;
    private final Set<ReplicatorConnection> connections = new HashSet<ReplicatorConnection>();
    private final FormattedBufferCache bufferCache = new FormattedBufferCache();

    public Replicator(int port) throws IOException {
        this.port = port;
        this.listen(port);
    }

    public Replicator() {
    }

    public void listen(int port) throws IOException {
        if (this.listener != null) {
            throw new IllegalStateException("already listening to port " + this.port);
        }
        this.listener = new Listener("replicator");
        this.listener.listen((ConnectionFactory)this, port);
        this.listener.start();
        log.log(LogLevel.CONFIG, "port=" + port);
    }

    @Override
    public synchronized boolean doHandle(LogMessage msg) {
        boolean logged = false;
        this.bufferCache.reset();
        for (ReplicatorConnection c : this.connections) {
            try {
                if (!c.isLoggable(msg)) continue;
                c.enqueue(this.bufferCache.getFormatted(msg, c.formatter));
                logged = true;
            }
            catch (IOException e) {
                log.log((Level)LogLevel.DEBUG, "Writing failed", e);
            }
        }
        return logged;
    }

    @Override
    public void close() {
        try {
            this.listener.interrupt();
            this.listener.join();
            log.log((Level)LogLevel.DEBUG, "Replicator listener stopped");
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "Replicator listener was interrupted", e);
        }
    }

    @Override
    public void flush() {
    }

    public synchronized Connection newConnection(SocketChannel socket, Listener listener) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.fine("New replicator connection: " + socket);
        }
        ReplicatorConnection n = new ReplicatorConnection(socket, listener, this);
        this.connections.add(n);
        return n;
    }

    protected synchronized void deRegisterConnection(ReplicatorConnection conn) {
        this.connections.remove(conn);
    }

    @Override
    public String toString() {
        return Replicator.class.getName();
    }
}

