/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.replicator;

import com.yahoo.log.LogMessage;
import com.yahoo.logserver.formatter.LogFormatter;
import com.yahoo.logserver.formatter.LogFormatterManager;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.IdentityHashMap;
import java.util.Map;

public class FormattedBufferCache {
    private static final Charset charset = Charset.forName("utf-8");
    private final IdentityHashMap<LogFormatter, ByteBuffer> buffers;

    public FormattedBufferCache() {
        int initialSize = LogFormatterManager.getFormatterNames().length * 2;
        this.buffers = new IdentityHashMap(initialSize);
    }

    public ByteBuffer getFormatted(LogMessage msg, LogFormatter formatter) {
        ByteBuffer bb = this.buffers.get(formatter);
        if (bb == null) {
            bb = charset.encode(formatter.format(msg));
            this.buffers.put(formatter, bb);
        }
        return bb.slice();
    }

    public void reset() {
        this.buffers.clear();
    }

    public Map<LogFormatter, ByteBuffer> getUnderlyingMapOnlyForTesting() {
        return this.buffers;
    }
}

