/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.logmetrics;

import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.log.event.Event;
import com.yahoo.logserver.filter.LevelFilter;
import com.yahoo.logserver.handlers.AbstractLogHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogMetricsHandler
extends AbstractLogHandler {
    private static final long EVENTINTERVAL = 300L;
    private static final Logger log = Logger.getLogger(LogMetricsHandler.class.getName());
    private final List<LevelCount> logMetrics = new ArrayList<LevelCount>();
    private static final Level[] levels = new Level[]{LogLevel.INFO, LogLevel.WARNING, LogLevel.SEVERE, LogLevel.ERROR, LogLevel.FATAL};

    public LogMetricsHandler() {
        LevelFilter filter = new LevelFilter();
        for (Level level : Arrays.asList(levels)) {
            filter.addLevel(level);
        }
        this.setLogFilter(filter);
        EventGenerator eventThread = new EventGenerator();
        new Thread(eventThread).start();
    }

    @Override
    public boolean doHandle(LogMessage message) {
        String host = message.getHost();
        Level logLevel = message.getLevel();
        boolean found = false;
        if (this.logMetrics.size() > 0) {
            for (int i = 0; i < this.logMetrics.size(); ++i) {
                LevelCount count = this.logMetrics.get(i);
                if (!count.getHost().equals(host) || !count.getLevel().getName().equals(logLevel.getName())) continue;
                count.addCount(1L);
                found = true;
                break;
            }
        }
        if (!found) {
            for (Level level : Arrays.asList(levels)) {
                LevelCount levelCount = level.getName().equals(logLevel.getName()) ? new LevelCount(host, level, 1L) : new LevelCount(host, level, 0L);
                this.logMetrics.add(levelCount);
            }
        }
        return true;
    }

    private void sendEvents() {
        Map<String, Long> levelCount = this.getMetricsPerLevel();
        for (Map.Entry<String, Long> entry : levelCount.entrySet()) {
            String key = entry.getKey();
            Long count = entry.getValue();
            Event.count((String)("log_message." + key.toLowerCase()), (long)count);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        return LogMetricsHandler.class.getName();
    }

    public long getMetricsCount() {
        long count = 0L;
        for (LevelCount levelCount : this.logMetrics) {
            count += levelCount.getCount();
        }
        return count;
    }

    public Map<String, Long> getMetricsPerLevel() {
        TreeMap<String, Long> levelCounts = new TreeMap<String, Long>();
        for (Level level : Arrays.asList(levels)) {
            String levelName = level.getName();
            long count = 0L;
            for (LevelCount levelCount : this.logMetrics) {
                if (!levelName.equals(levelCount.getLevel().getName())) continue;
                count += levelCount.getCount();
            }
            levelCounts.put(levelName, count);
        }
        return levelCounts;
    }

    private class EventGenerator
    implements Runnable {
        private EventGenerator() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    log.log(LogLevel.WARNING, e.getMessage());
                }
                LogMetricsHandler.this.sendEvents();
            }
        }
    }

    private class LevelCount {
        private final String host;
        private final Level level;
        private long count;

        LevelCount(String host, Level level, long count) {
            this.host = host;
            this.level = level;
            this.count = count;
        }

        LevelCount(String host, Level level) {
            this(host, level, 0L);
        }

        Level getLevel() {
            return this.level;
        }

        String getHost() {
            return this.host;
        }

        long getCount() {
            return this.count;
        }

        void setCount(long count) {
            this.count = count;
        }

        void addCount(long add) {
            this.count += add;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Host=" + this.host + ", level = " + this.level.getName() + ",count=" + this.count);
            return sb.toString();
        }
    }
}

