/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.replicator;

import com.yahoo.log.LogLevel;
import com.yahoo.logserver.Server;
import com.yahoo.logserver.handlers.replicator.Replicator;
import com.yahoo.plugin.Config;
import com.yahoo.plugin.Plugin;
import java.io.IOException;
import java.util.logging.Logger;

public class ReplicatorPlugin
implements Plugin {
    private static final String DEFAULT_PORT = "19083";
    private static final Logger log = Logger.getLogger(ReplicatorPlugin.class.getName());
    private Replicator replicator;
    private final Server server = Server.getInstance();

    @Override
    public String getPluginName() {
        return "replicator";
    }

    @Override
    public void initPlugin(Config config) {
        if (this.replicator != null) {
            throw new IllegalStateException("plugin already initialized: " + this.getPluginName());
        }
        int listenPort = config.getInt("port", DEFAULT_PORT);
        String threadName = config.get("thread", this.getPluginName());
        try {
            this.replicator = new Replicator(listenPort);
        }
        catch (IOException e) {
            log.log(LogLevel.WARNING, "init failed: " + e);
            return;
        }
        this.server.registerLogHandler(this.replicator, threadName);
    }

    @Override
    public void shutdownPlugin() {
        if (this.replicator == null) {
            throw new IllegalStateException("plugin not initialized: " + this.getPluginName());
        }
        this.server.unregisterLogHandler(this.replicator);
        this.replicator = null;
    }
}

