/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.lasterrorsholder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.io.Connection;
import com.yahoo.io.ConnectionFactory;
import com.yahoo.io.Listener;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.handlers.AbstractLogHandler;
import com.yahoo.logserver.handlers.lasterrorsholder.LastErrorsHolderConnection;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LastErrorsHolder
extends AbstractLogHandler
implements ConnectionFactory {
    private static final Logger log = Logger.getLogger(LastErrorsHolder.class.getName());
    private static final int maxNumErrors = 100;
    private final Object lock = new Object();
    private int port;
    private Listener listener;
    private final ArrayList<LogMessage> errors = new ArrayList();
    private int numberOfErrors = 0;

    public LastErrorsHolder(int port) throws IOException {
        this.port = port;
        this.listen(port);
    }

    public void listen(int port) throws IOException {
        if (this.listener != null) {
            throw new IllegalStateException("already listening to port " + this.port);
        }
        this.listener = new Listener("last-errors-holder");
        this.listener.listen((ConnectionFactory)this, port);
        this.listener.start();
        log.log(LogLevel.CONFIG, "port=" + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doHandle(LogMessage msg) {
        if (msg.getLevel().equals(LogLevel.ERROR) || msg.getLevel().equals(LogLevel.FATAL)) {
            Object object = this.lock;
            synchronized (object) {
                ++this.numberOfErrors;
                if (this.errors.size() < 100) {
                    this.errors.add(msg);
                } else if (this.numberOfErrors == 100) {
                    log.log((Level)LogLevel.DEBUG, String.format("Not storing errors, have reached maximum number of errors: %d, total number of errors received: %d", 100, this.numberOfErrors));
                }
            }
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this.listener.interrupt();
            this.listener.join();
            log.log((Level)LogLevel.DEBUG, "listener stopped");
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "listener was interrupted", e);
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection newConnection(SocketChannel socket, Listener listener) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "New last-errors-holder connection: " + socket);
        }
        LastErrorsHolderConnection connection = new LastErrorsHolderConnection(socket);
        Object object = this.lock;
        synchronized (object) {
            Messages messages = new Messages();
            for (LogMessage error : this.errors) {
                messages.addMessage(new Message(error.getTime() / 1000L, error.getHost(), error.getService(), error.getLevel().getName(), error.getPayload()));
            }
            messages.setNumberOfErrors(this.numberOfErrors);
            try {
                ObjectMapper mapper = new ObjectMapper();
                StringWriter stringWriter = new StringWriter();
                mapper.writeValue((Writer)stringWriter, (Object)messages);
                connection.enqueue(StandardCharsets.UTF_8.encode(stringWriter.toString()));
            }
            catch (IOException e) {
                log.log(LogLevel.WARNING, "Could not enqueue log message", e);
            }
            this.errors.clear();
            this.numberOfErrors = 0;
        }
        return connection;
    }

    @Override
    public String toString() {
        return LastErrorsHolder.class.getName();
    }

    static class Message {
        private final long time;
        private final String hostname;
        private final String service;
        private final String logLevel;
        private final String message;

        Message(long time, String hostname, String service, String logLevel, String message) {
            this.time = time;
            this.hostname = hostname;
            this.service = service;
            this.logLevel = logLevel;
            this.message = message;
        }

        public long getTime() {
            return this.time;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getService() {
            return this.service;
        }
    }

    static class Messages {
        private final List<Message> messages = new ArrayList<Message>();
        private long errorCount = 0L;

        Messages() {
        }

        void addMessage(Message message) {
            this.messages.add(message);
        }

        void setNumberOfErrors(long errorCount) {
            this.errorCount = errorCount;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public long getErrorCount() {
            return this.errorCount;
        }
    }
}

