/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.archive;

import com.yahoo.log.LogLevel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogWriter
extends Writer {
    private static final Logger log = Logger.getLogger(LogWriter.class.getName());
    private long bytesWritten = 0L;
    private int generation = 0;
    private int maxSize = 0x1400000;
    private final int resumeLimit = 95;
    private final int resumeLimitSize = this.maxSize * 95 / 100;
    private File currentFile;
    private Writer writer;
    private final String prefix;

    public LogWriter(String prefix, int maxSize) throws IOException {
        this.prefix = prefix;
        this.maxSize = maxSize;
        this.writer = this.nextWriter();
    }

    private Writer nextWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        int maxAttempts = 1000;
        while (maxAttempts-- > 0) {
            String name = this.prefix + "-" + this.generation++;
            File f = new File(name);
            File dir = f.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (new File(name + ".gz").exists() || new File(name + ".bz2").exists()) continue;
            if (!f.exists()) {
                log.log((Level)LogLevel.DEBUG, "nextWriter, new file: " + name);
                this.currentFile = f;
                this.bytesWritten = 0L;
                return new FileWriter(f, true);
            }
            if (!f.isFile()) {
                log.fine("nextWriter, " + name + " is a directory, skipping");
                continue;
            }
            if (f.length() < (long)this.resumeLimitSize) {
                log.fine("nextWriter, resuming " + name + ", length was " + f.length());
                this.currentFile = f;
                this.bytesWritten = f.length();
                return new FileWriter(f, true);
            }
            log.fine("nextWriter, not resuming " + name + " because it is bigger than " + 95 + " percent of max");
        }
        throw new RuntimeException("Unable to create next log file");
    }

    @Override
    public void write(char[] cbuff, int offset, int len) throws IOException {
        throw new RuntimeException("This method should not be used");
    }

    @Override
    public void write(String str) throws IOException {
        if (this.writer == null) {
            this.writer = this.nextWriter();
        }
        this.bytesWritten += (long)str.length();
        this.writer.write(str, 0, str.length());
        if (this.bytesWritten >= (long)this.maxSize) {
            log.fine("logfile '" + this.currentFile.getAbsolutePath() + "' full, rotating");
            this.writer = this.nextWriter();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }
}

