/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.significance.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.component.annotation.Inject;
import com.yahoo.language.Language;
import com.yahoo.language.significance.SignificanceModel;
import com.yahoo.language.significance.SignificanceModelRegistry;
import com.yahoo.language.significance.impl.DefaultSignificanceModel;
import com.yahoo.language.significance.impl.DocumentFrequencyFile;
import com.yahoo.language.significance.impl.SignificanceModelFile;
import com.yahoo.search.significance.config.SignificanceConfig;
import io.airlift.compress.zstd.ZstdInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public final class DefaultSignificanceModelRegistry
implements SignificanceModelRegistry {
    private static final Logger log = Logger.getLogger(DefaultSignificanceModelRegistry.class.getName());
    private final Map<Language, SignificanceModel> models = new EnumMap<Language, SignificanceModel>(Language.class);

    @Inject
    public DefaultSignificanceModelRegistry(SignificanceConfig cfg) {
        for (SignificanceConfig.Model model : cfg.model()) {
            this.addModel(model.path());
        }
    }

    public DefaultSignificanceModelRegistry(List<Path> models) {
        for (Path path : models) {
            this.addModel(path);
        }
    }

    public void addModel(Path path) {
        log.fine(() -> "Loading model from " + String.valueOf(path));
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Object in = path.toString().endsWith(".zst") ? new ZstdInputStream((InputStream)new FileInputStream(path.toFile())) : new FileInputStream(path.toFile());
            SignificanceModelFile file = (SignificanceModelFile)objectMapper.readValue((InputStream)in, SignificanceModelFile.class);
            for (Map.Entry<String, DocumentFrequencyFile> pair : file.languages().entrySet()) {
                String[] languageTags;
                String languagesStr = pair.getKey();
                log.fine(() -> "Found model for languages '%s'".formatted(languagesStr));
                for (String languageTag : languageTags = languagesStr.split(",")) {
                    Language language = Language.fromLanguageTag(languageTag);
                    log.fine(() -> "Adding model for language %s with id %s".formatted(new Object[]{language, file.id()}));
                    this.models.put(language, new DefaultSignificanceModel(pair.getValue(), file.id()));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load model from " + String.valueOf(path), e);
        }
    }

    @Override
    public Optional<SignificanceModel> getModel(Language language) {
        if (!this.models.containsKey((Object)language)) {
            return Optional.empty();
        }
        return Optional.of(this.models.get((Object)language));
    }
}

