/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import ai.vespa.llm.completion.Prompt;
import com.yahoo.collections.LazyMap;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.process.InvocationContext;
import java.util.Map;
import java.util.function.Function;

public interface FieldGenerator {
    public static final String defaultGeneratorId = "default";
    public static final FieldGenerator throwsOnUse = new FailingFieldGenerator();

    default public Map<String, FieldGenerator> asMap() {
        return this.asMap(defaultGeneratorId);
    }

    default public Map<String, FieldGenerator> asMap(String name) {
        return Map.of(name, this);
    }

    public FieldValue generate(Prompt var1, Context var2);

    public static class FailingFieldGenerator
    implements FieldGenerator {
        private final String message;

        public FailingFieldGenerator() {
            this("No generator has been configured");
        }

        public FailingFieldGenerator(String message) {
            this.message = message;
        }

        @Override
        public FieldValue generate(Prompt prompt, Context context) {
            throw new IllegalStateException(this.message);
        }

        public boolean equals(Object other) {
            return other.getClass().getName().equals(this.getClass().getName());
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public static Function<String, FieldGenerator> factory() {
            return FailingFieldGenerator::new;
        }
    }

    public static class Context
    extends InvocationContext<Context> {
        private final DataType targetType;

        public Context(String destination, DataType targetType) {
            this(destination, targetType, (Map<Object, Object>)LazyMap.newHashMap());
        }

        public Context(String destination, DataType targetType, Map<Object, Object> cache) {
            super(destination, cache);
            this.targetType = targetType;
        }

        public DataType getTargetType() {
            return this.targetType;
        }
    }
}

