/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.language.chunker;

import com.yahoo.language.process.CharacterClasses;
import com.yahoo.language.process.Chunker;
import com.yahoo.text.UnicodeString;
import java.util.ArrayList;
import java.util.List;

public class SentenceChunker
implements Chunker {
    private final CharacterClasses characters = new CharacterClasses();

    @Override
    public List<Chunker.Chunk> chunk(String inputText, Chunker.Context context) {
        return context.computeCachedValueIfAbsent(new CacheKey(this, inputText), () -> this.computeChunks(inputText));
    }

    private List<Chunker.Chunk> computeChunks(String inputText) {
        UnicodeString text = new UnicodeString(inputText);
        ArrayList<Chunker.Chunk> chunks = new ArrayList<Chunker.Chunk>();
        StringBuilder currentChunk = new StringBuilder();
        boolean currentHasContent = false;
        int i = 0;
        while (i < text.length()) {
            int currentChar = text.codePointAt(i);
            currentChunk.appendCodePoint(currentChar);
            if (currentHasContent && this.characters.isSentenceEnd(currentChar) && !this.characters.isSentenceEnd(text.nextCodePoint(i))) {
                chunks.add(new Chunker.Chunk(currentChunk.toString()));
                currentChunk.setLength(0);
                currentHasContent = false;
            } else {
                currentHasContent |= this.characters.isLetterOrDigit(currentChar) || this.characters.isSymbol(currentChar);
            }
            i = text.nextIndex(i);
        }
        if (!currentChunk.isEmpty()) {
            chunks.add(new Chunker.Chunk(currentChunk.toString()));
        }
        return chunks;
    }

    private record CacheKey(SentenceChunker chunker, String inputText) {
    }
}

