/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.api.annotations.Beta;
import com.yahoo.collections.LazyMap;
import com.yahoo.language.Language;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public interface Embedder {
    public static final String defaultEmbedderId = "default";
    public static final Embedder throwsOnUse = new FailingEmbedder();

    default public Map<String, Embedder> asMap() {
        return this.asMap(defaultEmbedderId);
    }

    default public Map<String, Embedder> asMap(String name) {
        return Map.of(name, this);
    }

    public List<Integer> embed(String var1, Context var2);

    default public String decode(List<Integer> tokens, Context context) {
        throw new UnsupportedOperationException("Decode is not implemented");
    }

    public Tensor embed(String var1, Context var2, TensorType var3);

    public static class FailingEmbedder
    implements Embedder {
        private final String message;

        public FailingEmbedder() {
            this("No embedder has been configured");
        }

        public FailingEmbedder(String message) {
            this.message = message;
        }

        @Override
        public List<Integer> embed(String text, Context context) {
            throw new IllegalStateException(this.message);
        }

        @Override
        public Tensor embed(String text, Context context, TensorType tensorType) {
            throw new IllegalStateException(this.message);
        }
    }

    public static class Context {
        private Language language = Language.UNKNOWN;
        private String destination;
        private String embedderId = "unknown";
        private final Map<Object, Object> cache;

        public Context(String destination) {
            this(destination, (Map<Object, Object>)LazyMap.newHashMap());
        }

        public Context(String destination, Map<Object, Object> cache) {
            this.destination = destination;
            this.cache = Objects.requireNonNull(cache);
        }

        private Context(Context other) {
            this.language = other.language;
            this.destination = other.destination;
            this.embedderId = other.embedderId;
            this.cache = other.cache;
        }

        public Context copy() {
            return new Context(this);
        }

        public Language getLanguage() {
            return this.language;
        }

        public Context setLanguage(Language language) {
            this.language = language != null ? language : Language.UNKNOWN;
            return this;
        }

        public String getDestination() {
            return this.destination;
        }

        public Context setDestination(String destination) {
            this.destination = destination;
            return this;
        }

        public String getEmbedderId() {
            return this.embedderId;
        }

        public Context setEmbedderId(String embedderId) {
            this.embedderId = embedderId;
            return this;
        }

        public void putCachedValue(Object key, Object value) {
            this.cache.put(key, value);
        }

        public Object getCachedValue(Object key) {
            return this.cache.get(key);
        }

        public <T> T computeCachedValueIfAbsent(Object key, Supplier<? extends T> supplier) {
            return (T)this.cache.computeIfAbsent(key, __ -> supplier.get());
        }
    }

    @Beta
    public static interface Runtime {
        public void sampleEmbeddingLatency(double var1, Context var3);

        public void sampleSequenceLength(long var1, Context var3);

        public static Runtime testInstance() {
            return new Runtime(){

                @Override
                public void sampleEmbeddingLatency(double millis, Context ctx) {
                }

                @Override
                public void sampleSequenceLength(long length, Context ctx) {
                }
            };
        }
    }
}

