/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.detect;

import com.yahoo.language.Language;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class Detection {
    private final Language language;
    private final String encodingName;
    private final boolean local;

    public Detection(Language language, String encodingName, boolean local) {
        this.language = language;
        this.encodingName = encodingName;
        this.local = local;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Charset getEncoding() {
        if (this.encodingName == null) {
            return null;
        }
        try {
            return Charset.forName(this.encodingName);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return null;
        }
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public boolean isLocal() {
        return this.local;
    }
}

